/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav.client;

import java.net.MalformedURLException;
import java.net.URL;

public class LNIClientUtils {
    public static final int INFINITY = -1;

    public static URL makeDAVURL(String endpoint, String davURI, String packager) throws MalformedURLException {
        int s = endpoint.lastIndexOf(47);
        if (s < 0) {
            throw new MalformedURLException("Illegal LNI SOAP endpoint, no path separators (/) found: " + endpoint);
        }
        String result = endpoint.substring(0, s);
        if (davURI != null) {
            result = result + davURI;
            if (packager != null) {
                result = result + "?package=" + packager;
            }
        }
        return new URL(result);
    }

    public static URL makeDAVURL(String endpoint, String davURI) throws MalformedURLException {
        return LNIClientUtils.makeDAVURL(endpoint, davURI, null);
    }

    public static String makeLNIURI(String endpoint, String davurl) throws MalformedURLException {
        URL emptyUrl = LNIClientUtils.makeDAVURL(endpoint, null, null);
        URL url = new URL(davurl);
        return url.getPath().substring(emptyUrl.getPath().length());
    }
}

