/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dspace.app.dav.client.LNIClientUtils;
import org.dspace.app.dav.client.LNISoapServlet;
import org.dspace.app.dav.client.LNISoapServletServiceLocator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class LNISmokeTest {
    private static final Logger log = Logger.getLogger(LNISmokeTest.class);
    private static final Namespace NS_DAV = Namespace.getNamespace((String)"DAV:");
    private static XMLOutputter outputPretty = new XMLOutputter(Format.getPrettyFormat());
    private static final String allProp = "<propfind xmlns=\"DAV:\"><allprop /></propfind>";
    private static final String nameProp = "<propfind xmlns=\"DAV:\"><propname /></propfind>";
    private static final String someProp = "<propfind xmlns=\"DAV:\"><prop><displayname/><dspace:type xmlns:dspace=\"http://www.dspace.org/xmlns/dspace\" /></prop></propfind>";
    private static final String specificPropPrefix = "<propfind xmlns=\"DAV:\" xmlns:dspace=\"http://www.dspace.org/xmlns/dspace\">  <prop><";
    private static final String specificPropSuffix = "/></prop></propfind>";

    private static void usage(Options options, int status, String msg) {
        HelpFormatter hf = new HelpFormatter();
        if (msg != null) {
            System.out.println(msg + "\n");
        }
        hf.printHelp("LNISmokeTest\n       -e SOAP-endpoint-URL\n       [ -s collection-handle -P package -i path ] |\n       [ -d item-handle -P package -o path ] |\n       [ -f handle [ -N propertyName ] ] |\n       [ -r handle [ -N propertyName ] ] |\n       [ -n handle ] |\n       [ -p handle  -N propertyName -V newvalue ] |\n       [ -d item-handle -C collection-handle ]\n", options, false);
        System.exit(status);
    }

    public static void main(String[] argv) throws Exception {
        Options options = new Options();
        OptionGroup func = new OptionGroup();
        func.addOption(new Option("c", "copy", true, "copy <Item> to -C <Collection>"));
        func.addOption(new Option("s", "submit", true, "submit <collection> -P <packager> -i <file>"));
        func.addOption(new Option("d", "disseminate", true, "disseminate <item> -P <packager> -o <file>"));
        func.addOption(new Option("f", "propfind", true, "propfind of all properties or -N <propname>"));
        func.addOption(new Option("r", "rpropfind", true, "recursive propfind, only collections"));
        func.addOption(new Option("n", "names", true, "list all property names on resource"));
        func.addOption(new Option("p", "proppatch", true, "set property: <handle> -N <property> -V <newvalue>"));
        func.setRequired(true);
        options.addOptionGroup(func);
        options.addOption("h", "help", false, "show help message");
        options.addOption("e", "endpoint", true, "SOAP endpoint URL (REQUIRED)");
        options.addOption("P", "packager", true, "Packager to use to import/export a package.");
        options.addOption("C", "collection", true, "Target collection of -c copy");
        options.addOption("o", "output", true, "file to create for new package");
        options.addOption("i", "input", true, "file containing package to submit");
        options.addOption("N", "name", true, "name of property to query/set");
        options.addOption("V", "value", true, "new value for property being set");
        try {
            String endpoint;
            CommandLine line = new PosixParser().parse(options, argv);
            if (line.hasOption("h")) {
                LNISmokeTest.usage(options, 0, null);
            }
            if ((endpoint = line.getOptionValue("e")) == null) {
                LNISmokeTest.usage(options, 2, "Missing the required -e endpoint argument");
            }
            LNISoapServletServiceLocator loc = new LNISoapServletServiceLocator();
            LNISoapServlet lni = loc.getDSpaceLNI(new URL(endpoint));
            if (line.hasOption("f")) {
                String pfXml = line.hasOption("N") ? specificPropPrefix + line.getOptionValue("N") + specificPropSuffix : allProp;
                LNISmokeTest.doPropfind(lni, line.getOptionValue("f"), pfXml, 0, null);
            } else if (line.hasOption("r")) {
                LNISmokeTest.doPropfind(lni, line.getOptionValue("r"), someProp, -1, "collection,community");
            } else if (line.hasOption("n")) {
                LNISmokeTest.doPropfind(lni, line.getOptionValue("n"), nameProp, 0, null);
            } else if (line.hasOption("p")) {
                if (line.hasOption("N") && line.hasOption("V")) {
                    LNISmokeTest.doProppatch(lni, line.getOptionValue("p"), line.getOptionValue("N"), line.getOptionValue("V"));
                } else {
                    LNISmokeTest.usage(options, 13, "Missing required args: -N <name> -V <value>n");
                }
            } else if (line.hasOption("s")) {
                if (line.hasOption("P") && line.hasOption("i")) {
                    LNISmokeTest.doPut(lni, line.getOptionValue("s"), line.getOptionValue("P"), line.getOptionValue("i"), endpoint);
                } else {
                    LNISmokeTest.usage(options, 13, "Missing required args after -s: -P <packager> -i <file>");
                }
            } else if (line.hasOption("d")) {
                if (line.hasOption("P") && line.hasOption("o")) {
                    LNISmokeTest.doGet(lni, line.getOptionValue("d"), line.getOptionValue("P"), line.getOptionValue("o"), endpoint);
                } else {
                    LNISmokeTest.usage(options, 13, "Missing required args after -d: -P <packager> -o <file>");
                }
            } else if (line.hasOption("c")) {
                if (line.hasOption("C")) {
                    LNISmokeTest.doCopy(lni, line.getOptionValue("c"), line.getOptionValue("C"));
                } else {
                    LNISmokeTest.usage(options, 13, "Missing required args after -c: -C <collection>\n");
                }
            } else {
                LNISmokeTest.usage(options, 14, "Missing command option.\n");
            }
        }
        catch (ParseException pe) {
            LNISmokeTest.usage(options, 1, "Error in arguments: " + pe.toString());
        }
        catch (RemoteException de) {
            System.out.println("ERROR, got RemoteException, message=" + de.getMessage());
            de.printStackTrace();
            LNISmokeTest.die(1, "  Exception class=" + de.getClass().getName());
        }
    }

    private static void die(int exit, String msg) {
        System.err.println(msg);
        System.exit(exit);
    }

    private static String doLookup(LNISoapServlet lni, String handle, String bitstream) throws RemoteException {
        String uri;
        if (handle.startsWith("/") && bitstream == null) {
            return handle;
        }
        if (handle.indexOf(32) >= 0 && bitstream == null) {
            String[] h = handle.split("\\s+");
            handle = h[0];
            bitstream = h[1];
        }
        if ((uri = lni.lookup(handle, bitstream)) == null) {
            LNISmokeTest.die(2, "ERROR, got null from lookup(\"" + handle + "\")");
        }
        System.out.println("DEBUG: lookup returns: \"" + uri + "\"");
        return uri;
    }

    private static void doPropfind(LNISoapServlet lni, String handle, String pf, int depth, String types) throws RemoteException, IOException {
        String uri = LNISmokeTest.doLookup(lni, handle, null);
        String result = lni.propfind(uri, pf, depth, types);
        try {
            SAXBuilder builder = new SAXBuilder();
            Document msDoc = builder.build((Reader)new StringReader(result));
            Element ms = msDoc.getRootElement();
            ListIterator ri = ms.getChildren("response", NS_DAV).listIterator();
            while (ri.hasNext()) {
                Element resp = (Element)ri.next();
                String href = resp.getChildText("href", NS_DAV);
                System.out.println("Resource = " + href);
                ListIterator pi = resp.getChildren("propstat", NS_DAV).listIterator();
                while (pi.hasNext()) {
                    Element ps = (Element)pi.next();
                    String status = ps.getChildText("status", NS_DAV);
                    if (status.indexOf("200") >= 0) {
                        System.out.println("  === PROPERTIES Successfully returned:");
                    } else {
                        System.out.println("  === PROPERTIES with Status=" + status);
                    }
                    Element prop = ps.getChild("prop", NS_DAV);
                    ListIterator ppi = prop.getChildren().listIterator();
                    while (ppi.hasNext()) {
                        Element e = (Element)ppi.next();
                        String value = e.getTextTrim();
                        if (value.equals("")) {
                            List kids = e.getChildren();
                            if (kids.size() > 0) {
                                value = outputPretty.outputString(kids);
                            }
                            if (value.indexOf(10) >= 0) {
                                value = "\n" + value;
                            }
                        } else {
                            value = "\"" + value + "\"";
                        }
                        String equals = value.equals("") ? "" : " = ";
                        System.out.println("    " + e.getQualifiedName() + equals + value);
                    }
                }
            }
        }
        catch (JDOMParseException je) {
            je.printStackTrace();
            LNISmokeTest.die(3, "ERROR: " + je.toString());
        }
        catch (JDOMException je) {
            je.printStackTrace();
            LNISmokeTest.die(4, "ERROR: " + je.toString());
        }
    }

    private static void doProppatch(LNISoapServlet lni, String handle, String prop, String val) throws RemoteException {
        String uri = LNISmokeTest.doLookup(lni, handle, null);
        String action = val.length() > 0 ? "set" : "remove";
        String pupdate = "<propertyupdate xmlns=\"DAV:\" xmlns:dspace=\"http://www.dspace.org/xmlns/dspace\"><" + action + "><prop><" + prop + ">" + val + "</" + prop + "></prop></" + action + "></propertyupdate>";
        System.err.println("DEBUG: sending: " + pupdate);
        String result = lni.proppatch(uri, pupdate);
        System.err.println("RESULT: " + result);
    }

    private static void doCopy(LNISoapServlet lni, String src, String dst) throws RemoteException {
        String srcUri = LNISmokeTest.doLookup(lni, src, null);
        String dstUri = LNISmokeTest.doLookup(lni, dst, null);
        int status = lni.copy(srcUri, dstUri, -1, false, true);
        System.err.println("Copy status = " + String.valueOf(status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doPut(LNISoapServlet lni, String collHandle, String packager, String source, String endpoint) throws RemoteException, ProtocolException, IOException, FileNotFoundException {
        String collURI = LNISmokeTest.doLookup(lni, collHandle, null);
        URL url = LNIClientUtils.makeDAVURL(endpoint, collURI, packager);
        System.err.println("DEBUG: PUT file=" + source + " to URL=" + url.toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        conn.setDoOutput(true);
        LNISmokeTest.fixBasicAuth(url, conn);
        conn.connect();
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = conn.getOutputStream();
            LNISmokeTest.copyStream(in, out);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to close input stream", (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to close output stream", (Throwable)e);
                }
            }
        }
        int status = conn.getResponseCode();
        if (status < 200 || status >= 300) {
            LNISmokeTest.die(status, "HTTP error, status=" + String.valueOf(status) + ", message=" + conn.getResponseMessage());
        }
        System.err.println("DEBUG: sent " + source);
        System.err.println("RESULT: Status=" + String.valueOf(conn.getResponseCode()) + " " + conn.getResponseMessage());
        String loc = conn.getHeaderField("Location");
        System.err.println("RESULT: Location=" + (loc == null ? "NULL!" : loc));
    }

    private static void doGet(LNISoapServlet lni, String itemHandle, String packager, String output, String endpoint) throws RemoteException, ProtocolException, IOException, FileNotFoundException {
        String itemURI = LNISmokeTest.doLookup(lni, itemHandle, null);
        URL url = LNIClientUtils.makeDAVURL(endpoint, itemURI, packager);
        System.err.println("DEBUG: GET from URL: " + url.toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoInput(true);
        LNISmokeTest.fixBasicAuth(url, conn);
        conn.connect();
        int status = conn.getResponseCode();
        if (status < 200 || status >= 300) {
            LNISmokeTest.die(status, "HTTP error, status=" + String.valueOf(status) + ", message=" + conn.getResponseMessage());
        }
        InputStream in = conn.getInputStream();
        FileOutputStream out = new FileOutputStream(output);
        LNISmokeTest.copyStream(in, out);
        in.close();
        ((OutputStream)out).close();
        System.err.println("DEBUG: Created local file " + output);
        System.err.println("RESULT: Status=" + String.valueOf(conn.getResponseCode()) + " " + conn.getResponseMessage());
    }

    private static void fixBasicAuth(URL url, HttpURLConnection conn) {
        String userinfo = url.getUserInfo();
        if (userinfo != null) {
            String cui = new String(Base64.encodeBase64((byte[])userinfo.getBytes()));
            conn.addRequestProperty("Authorization", "Basic " + cui);
            System.err.println("DEBUG: Sending Basic auth=" + cui);
        }
    }

    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int count;
        int BUFFER_SIZE = 4096;
        byte[] buffer = new byte[4096];
        while (-1 != (count = input.read(buffer, 0, 4096))) {
            output.write(buffer, 0, count);
        }
    }
}

