/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.dav.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.dspace.app.dav.client.DSpaceLNISoapBindingStub;
import org.dspace.app.dav.client.LNISoapServlet;
import org.dspace.app.dav.client.LNISoapServletService;

public class LNISoapServletServiceLocator
extends Service
implements LNISoapServletService {
    private String DSpaceLNI_address = "http://localhost/dspace/lni/DSpaceLNI";
    private String DSpaceLNIWSDDServiceName = "DSpaceLNI";
    private Set ports = null;

    public LNISoapServletServiceLocator() {
    }

    public LNISoapServletServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public LNISoapServletServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getDSpaceLNIAddress() {
        return this.DSpaceLNI_address;
    }

    public String getDSpaceLNIWSDDServiceName() {
        return this.DSpaceLNIWSDDServiceName;
    }

    public void setDSpaceLNIWSDDServiceName(String name) {
        this.DSpaceLNIWSDDServiceName = name;
    }

    @Override
    public LNISoapServlet getDSpaceLNI() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.DSpaceLNI_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getDSpaceLNI(endpoint);
    }

    @Override
    public LNISoapServlet getDSpaceLNI(URL portAddress) throws ServiceException {
        try {
            DSpaceLNISoapBindingStub _stub = new DSpaceLNISoapBindingStub(portAddress, this);
            _stub.setPortName(this.getDSpaceLNIWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setDSpaceLNIEndpointAddress(String address) {
        this.DSpaceLNI_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (LNISoapServlet.class.isAssignableFrom(serviceEndpointInterface)) {
                DSpaceLNISoapBindingStub _stub = new DSpaceLNISoapBindingStub(new URL(this.DSpaceLNI_address), this);
                _stub.setPortName(this.getDSpaceLNIWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("DSpaceLNI".equals(inputPortName)) {
            return this.getDSpaceLNI();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://dspace.org/xmlns/lni", "LNISoapServletService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://dspace.org/xmlns/lni", "DSpaceLNI"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"DSpaceLNI".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setDSpaceLNIEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

