/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.didl;

import java.io.Serializable;

public final class UUID
implements Serializable {
    private long hi;
    private long lo;

    public UUID(UUID uuid) {
        this.hi = uuid.hi;
        this.lo = uuid.lo;
    }

    public UUID(long _hi, long _lo) {
        this.hi = _hi;
        this.lo = _lo;
        this.lo &= 0x3FFFFFFFFFFFFFFFL;
        this.lo |= Long.MIN_VALUE;
        this.lo |= 0x800000000000L;
        this.hi &= 0xFFFFFFFFFFFF0FFFL;
        this.hi |= 0x4000L;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UUID) {
            return this.equals((UUID)obj);
        }
        return false;
    }

    public boolean equals(UUID uuid) {
        return this.hi == uuid.hi && this.lo == uuid.lo;
    }

    public int hashCode() {
        return new Long(this.hi ^ this.lo).hashCode();
    }

    public String toString() {
        return UUID.hexDigits(this.hi >> 32, 4) + "-" + UUID.hexDigits(this.hi >> 16, 2) + "-" + UUID.hexDigits(this.hi, 2) + "-" + UUID.hexDigits(this.lo >> 48, 2) + "-" + UUID.hexDigits(this.lo, 6);
    }

    private static String hexDigits(long lVal, int nHexOctets) {
        long tmp = 1L << nHexOctets * 2 * 4;
        long result = lVal & tmp - 1L;
        result = tmp | result;
        return Long.toHexString(result).substring(1);
    }
}

