/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.oai;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dspace.app.util.MetadataExposure;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.IConverter;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.PluginManager;
import org.dspace.search.HarvestedItemInfo;

public class OAIDCCrosswalk
extends Crosswalk {
    private static final Pattern invalidXmlPattern = Pattern.compile("([^\\t\\n\\r\\u0020-\\ud7ff\\ue000-\\ufffd\\u10000-\\u10ffff]+|[&<>])");
    private static final Pattern converterPattern = Pattern.compile(".*\\((.*)\\)");
    private static final String[] oaidcElement = new String[]{"title", "creator", "subject", "description", "publisher", "contributor", "date", "type", "format", "identifier", "source", "language", "relation", "coverage", "rights"};
    private static final String configFilePath = ConfigurationManager.getProperty((String)"dspace.dir") + File.separator + "config" + File.separator + "crosswalks" + File.separator + "oaidc.properties";
    private static Logger log = Logger.getLogger(OAIDCCrosswalk.class);
    private static final Map<String, Set<String>> config = new HashMap<String, Set<String>>();

    public OAIDCCrosswalk(Properties properties) {
        super("http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd");
    }

    public boolean isAvailableFor(Object nativeItem) {
        return true;
    }

    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        Item item = ((HarvestedItemInfo)nativeItem).item;
        StringBuffer metadata = new StringBuffer();
        metadata.append("<oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" ").append("xmlns:dc=\"http://purl.org/dc/elements/1.1/\" ").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ").append("xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd\">");
        for (String element : oaidcElement) {
            Set<String> itemMetadata = config.get(element);
            if (itemMetadata == null || itemMetadata.size() <= 0) continue;
            for (String mdString : itemMetadata) {
                String converterName = null;
                IConverter converter = null;
                Matcher converterMatcher = converterPattern.matcher(mdString);
                if (converterMatcher.matches() && (converter = (IConverter)PluginManager.getNamedPlugin(IConverter.class, (String)(converterName = converterMatcher.group(1)))) == null) {
                    log.warn((Object)LogManager.getHeader(null, (String)"createMetadata", (String)("no converter plugin found with name " + converterName + " for metadata " + mdString)));
                }
                DCValue[] dcValues = converterName != null ? item.getMetadata(mdString.replaceAll("\\(" + converterName + "\\)", "")) : item.getMetadata(mdString);
                try {
                    for (DCValue dcValue : dcValues) {
                        String value;
                        if (MetadataExposure.isHidden((Context)((HarvestedItemInfo)nativeItem).context, (String)dcValue.schema, (String)dcValue.element, (String)dcValue.qualifier) || (value = converter != null ? converter.makeConversion(dcValue.value) : dcValue.value) == null) continue;
                        StringBuffer valueBuf = new StringBuffer(value.length());
                        Matcher xmlMatcher = invalidXmlPattern.matcher(value.trim());
                        while (xmlMatcher.find()) {
                            String group = xmlMatcher.group();
                            if (group.equals("&")) {
                                xmlMatcher.appendReplacement(valueBuf, "&amp;");
                                continue;
                            }
                            if (group.equals("<")) {
                                xmlMatcher.appendReplacement(valueBuf, "&lt;");
                                continue;
                            }
                            if (group.equals(">")) {
                                xmlMatcher.appendReplacement(valueBuf, "&gt;");
                                continue;
                            }
                            xmlMatcher.appendReplacement(valueBuf, " ");
                        }
                        xmlMatcher.appendTail(valueBuf);
                        metadata.append("<dc:").append(element).append(">").append(valueBuf.toString()).append("</dc:").append(element).append(">");
                    }
                }
                catch (SQLException e) {
                    throw new CannotDisseminateFormatException(e.toString());
                }
            }
        }
        metadata.append("</oai_dc:dc>");
        return metadata.toString();
    }

    static {
        Properties crosswalkProps = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFilePath);
            crosswalkProps.load(fis);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Wrong configuration for OAI_DC", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    log.error((Object)ioe);
                }
            }
        }
        Set<Object> keySet = crosswalkProps.keySet();
        if (keySet != null) {
            for (Object key : keySet) {
                String oaielement = crosswalkProps.getProperty((String)key);
                if (oaielement == null || oaielement.trim().equals("")) continue;
                Set<String> tmp = config.get(oaielement);
                if (tmp == null) {
                    tmp = new HashSet<String>();
                }
                tmp.add((String)key);
                config.put(oaielement, tmp);
            }
        } else {
            throw new IllegalArgumentException("Configurazione errata per l'uscita OAI_DC");
        }
    }
}

