/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.oai;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.ServerVerb;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dspace.app.didl.UUIDFactory;
import org.dspace.app.oai.OAIDCCrosswalk;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.search.HarvestedItemInfo;
import org.dspace.storage.bitstore.BitstreamStorageManager;

public class DIDLCrosswalk
extends Crosswalk {
    private static final Logger log = Logger.getLogger(DIDLCrosswalk.class);
    public static final int MAXRESPONSE_INLINE_BITSTREAM = 0;
    private Crosswalk metadataCrosswalk;

    public DIDLCrosswalk(Properties properties) {
        super("urn:mpeg:mpeg21:2002:02-DIDL-NS http://standards.iso.org/ittf/PubliclyAvailableStandards/MPEG-21_schema_files/did/didl.xsd ");
        this.metadataCrosswalk = new OAIDCCrosswalk(properties);
    }

    public boolean isAvailableFor(Object nativeItem) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        StringBuffer metadata;
        block23: {
            Item item = ((HarvestedItemInfo)nativeItem).item;
            metadata = new StringBuffer();
            String itemhandle = item.getHandle();
            String strMaxSize = ConfigurationManager.getProperty((String)"oai.didl.maxresponse");
            int maxsize = 0;
            if (strMaxSize != null) {
                maxsize = Integer.parseInt(strMaxSize);
            }
            String currdate = ServerVerb.createResponseDate((Date)new Date());
            metadata.append("<didl:DIDL ").append(" xmlns:didl=\"urn:mpeg:mpeg21:2002:02-DIDL-NS\"  ").append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ").append("xsi:schemaLocation=\"urn:mpeg:mpeg21:2002:02-DIDL-NS http://standards.iso.org/ittf/PubliclyAvailableStandards/MPEG-21_schema_files/did/didl.xsd \">").append("<didl:DIDLInfo>").append("<dcterms:created xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://purl.org/dc/terms/ \">").append(currdate).append("</dcterms:created> </didl:DIDLInfo>").append("<didl:Item id=\"").append("uuid-" + UUIDFactory.generateUUID().toString() + "\">");
            metadata.append("<didl:Descriptor>").append("<didl:Statement mimeType=\"application/xml; charset=utf-8\">").append("<dii:Identifier xmlns:dii=\"urn:mpeg:mpeg21:2002:01-DII-NS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:mpeg:mpeg21:2002:01-DII-NS http://standards.iso.org/ittf/PubliclyAvailableStandards/MPEG-21_schema_files/dii/dii.xsd\">").append("urn:hdl:").append(itemhandle).append("</dii:Identifier>").append("</didl:Statement>").append("</didl:Descriptor>");
            metadata.append("<didl:Descriptor>").append("<didl:Statement mimeType=\"application/xml; charset=utf-8\">");
            metadata.append(this.metadataCrosswalk.createMetadata(nativeItem));
            metadata.append("</didl:Statement>").append("</didl:Descriptor>");
            try {
                Bundle[] bundles = item.getBundles("ORIGINAL");
                if (bundles.length == 0) break block23;
                for (int i = 0; i < bundles.length; ++i) {
                    boolean flag = false;
                    Bitstream[] bitstreams = bundles[i].getBitstreams();
                    for (int k = 0; k < bitstreams.length; ++k) {
                        if (bitstreams[k].getFormat().isInternal()) continue;
                        if (!flag) {
                            flag = true;
                        }
                        metadata.append("<didl:Component id=\"uuid-" + UUIDFactory.generateUUID().toString() + "\">");
                        if (bitstreams[k].getSize() > (long)maxsize) {
                            metadata.append("<didl:Resource ref=\"" + ConfigurationManager.getProperty((String)"dspace.url") + "/bitstream/" + itemhandle + "/" + bitstreams[k].getSequenceID() + "/" + bitstreams[k].getName());
                            metadata.append("\" mimeType=\"");
                            metadata.append(bitstreams[k].getFormat().getMIMEType());
                            metadata.append("\">");
                            metadata.append("</didl:Resource>");
                        } else {
                            try {
                                metadata.append("<didl:Resource mimeType=\"");
                                metadata.append(bitstreams[k].getFormat().getMIMEType());
                                metadata.append("\" encoding=\"base64\">");
                                int intSize = (int)bitstreams[k].getSize();
                                byte[] buffer = new byte[intSize];
                                Context contextl = new Context();
                                InputStream is = BitstreamStorageManager.retrieve((Context)contextl, (int)bitstreams[k].getID());
                                BufferedInputStream bis = new BufferedInputStream(is);
                                try {
                                    bis.read(buffer);
                                }
                                finally {
                                    if (bis != null) {
                                        try {
                                            bis.close();
                                        }
                                        catch (IOException ioe) {}
                                    }
                                    if (is != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (IOException ioe) {}
                                    }
                                }
                                contextl.complete();
                                String encoding = new String(Base64.encodeBase64((byte[])buffer), "ASCII");
                                metadata.append(encoding);
                            }
                            catch (Exception ex) {
                                log.error((Object)"Error creating resource didl", (Throwable)ex);
                                metadata.append("<didl:Resource ref=\"").append(ConfigurationManager.getProperty((String)"dspace.url")).append("/bitstream/").append(itemhandle).append("/").append(bitstreams[k].getSequenceID()).append("/").append(bitstreams[k].getName());
                                metadata.append("\" mimeType=\"");
                                metadata.append(bitstreams[k].getFormat().getMIMEType());
                                metadata.append("\">");
                            }
                            metadata.append("</didl:Resource>");
                        }
                        metadata.append("</didl:Component>");
                    }
                }
            }
            catch (SQLException sqle) {
                System.err.println("Caught exception:" + sqle.getCause());
                log.error((Object)"Database error", (Throwable)sqle);
            }
        }
        metadata.append("</didl:Item>").append("</didl:DIDL>");
        return metadata.toString();
    }
}

