/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.oai;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Utils;
import org.dspace.search.HarvestedItemInfo;

public class UKETDDCCrosswalk
extends Crosswalk {
    private static final Pattern invalidXmlPattern = Pattern.compile("([^\\t\\n\\r\\u0020-\\ud7ff\\ue000-\\ufffd\\u10000-\\u10ffff]+|[&<>])");
    private String uketdIn = "<uketd_dc:uketddc";
    private String uketdNs = "uketd_dc";
    private String uketdUri = "http://naca.central.cranfield.ac.uk/ethos-oai/2.0/";
    private String dcNs = "dc";
    private String dcUri = "http://purl.org/dc/elements/1.1/";
    private String dcTermsNs = "dcterms";
    private String dcTermsUri = "http://purl.org/dc/terms/";
    private String uketdTermsNs = "uketdterms";
    private String uketdTermsUri = "http://naca.central.cranfield.ac.uk/ethos-oai/terms/";
    private String xsi = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
    private String schemaLoc = "xsi:schemaLocation";
    private static String uketdSchemaLocNs = "http://naca.central.cranfield.ac.uk/ethos-oai/2.0/";
    private static String uketdSchemaLocUri = "http://naca.central.cranfield.ac.uk/ethos-oai/2.0/uketd_dc.xsd";

    public UKETDDCCrosswalk(Properties properties) {
        super(uketdSchemaLocNs + " " + uketdSchemaLocUri);
    }

    public String getUketdNs() {
        return this.uketdNs;
    }

    public String getUketdUri() {
        return this.uketdUri;
    }

    public String getDcNs() {
        return this.dcNs;
    }

    public String getDcUri() {
        return this.dcUri;
    }

    public String getDcTermsNs() {
        return this.dcTermsNs;
    }

    public String getDcTermsUri() {
        return this.dcTermsUri;
    }

    public String getUketdTermsNs() {
        return this.uketdTermsNs;
    }

    public String getUketdTermsUri() {
        return this.uketdTermsUri;
    }

    public String getUketdSchemaLocNs() {
        return uketdSchemaLocNs;
    }

    public String getUketdSchemaLocUri() {
        return uketdSchemaLocUri;
    }

    public boolean isAvailableFor(Object nativeItem) {
        return true;
    }

    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        Item item = ((HarvestedItemInfo)nativeItem).item;
        return this.writeMetadataWithSchema(item);
    }

    public String writeMetadataWithSchema(Item item) {
        StringBuffer metadata = new StringBuffer();
        metadata.append(this.uketdIn).append(" ");
        metadata.append("xmlns:" + this.uketdNs + "=\"" + this.uketdUri + "\" ");
        metadata.append("xmlns:" + this.dcNs + "=\"" + this.dcUri + "\" ");
        metadata.append("xmlns:" + this.dcTermsNs + "=\"" + this.dcTermsUri + "\" ");
        metadata.append("xmlns:" + this.uketdTermsNs + "=\"" + this.uketdTermsUri + "\" ");
        metadata.append(this.xsi).append(" ");
        metadata.append(this.schemaLoc + "=\"" + uketdSchemaLocNs + " ");
        metadata.append(uketdSchemaLocUri).append("\">\n");
        metadata.append(this.writeMetadata(item));
        metadata.append("</uketd_dc:uketddc>\n");
        return metadata.toString();
    }

    public String writeMetadata(Item item) {
        StringBuffer metadata = new StringBuffer();
        DCValue[] allDC = item.getMetadata("dc", "*", "*", "*");
        String itemhandle = item.getHandle();
        for (int i = 0; i < allDC.length; ++i) {
            String element = allDC[i].element;
            String qualifier = allDC[i].qualifier;
            String value = Utils.addEntities((String)allDC[i].value);
            if (allDC[i].element.equals("title")) {
                if (allDC[i].qualifier != null) {
                    if (allDC[i].qualifier.equals("alternative")) {
                        this.makeDCTermsElement(qualifier, null, value, metadata);
                    }
                } else {
                    this.makeDCElement(element, null, value, metadata);
                }
            }
            if (allDC[i].element.equals("contributor")) {
                if (allDC[i].qualifier != null) {
                    if (allDC[i].qualifier.equals("author")) {
                        this.makeDCElement("creator", null, value, metadata);
                    } else if (allDC[i].qualifier.equals("advisor") || allDC[i].qualifier.equals("sponsor")) {
                        this.makeUKDCTermsElement(qualifier, null, value, metadata);
                    } else if (allDC[i].qualifier.equals("funder")) {
                        this.makeUKDCTermsElement("sponsor", null, value, metadata);
                    } else {
                        this.makeDCTermsElement(qualifier, null, value, metadata);
                    }
                } else {
                    this.makeDCElement(element, null, value, metadata);
                }
            }
            if (allDC[i].element.equals("subject")) {
                if (allDC[i].qualifier != null) {
                    boolean ddc = allDC[i].qualifier.equals("ddc");
                    boolean lcc = allDC[i].qualifier.equals("lcc");
                    boolean lcsh = allDC[i].qualifier.equals("lcsh");
                    boolean mesh = allDC[i].qualifier.equals("mesh");
                    boolean udc = allDC[i].qualifier.equals("udc");
                    if (ddc || lcc || lcsh || mesh || udc) {
                        qualifier = qualifier.toUpperCase();
                        this.makeDCElement(element, qualifier, value, metadata);
                    } else {
                        this.makeDCElement(element, null, value, metadata);
                    }
                } else {
                    this.makeDCElement(element, null, value, metadata);
                }
            }
            if (allDC[i].element.equals("description")) {
                if (allDC[i].qualifier != null) {
                    if (allDC[i].qualifier.equals("abstract")) {
                        this.makeDCTermsElement(qualifier, null, value, metadata);
                    } else if (allDC[i].qualifier.equals("sponsorship")) {
                        this.makeUKDCTermsElement("sponsor", null, value, metadata);
                    }
                } else {
                    this.makeDCElement(element, null, value, metadata);
                }
            }
            if (allDC[i].element.equals("publisher")) {
                if (allDC[i].qualifier != null) {
                    if (allDC[i].qualifier.equals("department") || allDC[i].qualifier.equals("commercial")) {
                        this.makeUKDCTermsElement(qualifier, null, value, metadata);
                    }
                } else {
                    String[] pubParts = value.split("(?<!(&[0-9a-zA-Z#]{2,4}));");
                    this.makeUKDCTermsElement("institution", null, pubParts[0], metadata);
                    StringBuffer dept = new StringBuffer();
                    if (pubParts.length > 1 && pubParts[1] != null) {
                        dept.append(pubParts[1] + ";");
                    }
                    if (pubParts.length > 2 && pubParts[2] != null) {
                        dept.append(" " + pubParts[2]);
                    }
                    if (dept.length() > 0) {
                        this.makeUKDCTermsElement("department", null, dept.toString(), metadata);
                    }
                }
            }
            if (allDC[i].element.equals("date")) {
                if (allDC[i].qualifier != null) {
                    if (allDC[i].qualifier.equals("issued")) {
                        this.makeDCTermsElement(qualifier, null, value, metadata);
                    } else {
                        this.makeDCElement(element, null, value, metadata);
                    }
                } else {
                    this.makeDCElement(element, null, value, metadata);
                }
            }
            if (allDC[i].element.equals("type")) {
                if (allDC[i].qualifier != null) {
                    if (allDC[i].qualifier.equals("qualificationlevel") || allDC[i].qualifier.equals("qualificationname")) {
                        this.makeUKDCTermsElement(qualifier, null, value, metadata);
                    }
                } else {
                    String[] Typepart = value.split("[;]");
                    this.makeDCElement(element, null, Typepart[0], metadata);
                    if (Typepart.length > 1 && Typepart[1] != null) {
                        this.makeUKDCTermsElement("qualificationlevel", null, Typepart[1], metadata);
                    }
                    if (Typepart.length > 2 && Typepart[2] != null) {
                        this.makeUKDCTermsElement("qualificationname", null, Typepart[2], metadata);
                    }
                }
            }
            if (allDC[i].element.equals("language")) {
                if (allDC[i].qualifier != null) {
                    if (allDC[i].qualifier.equals("iso")) {
                        this.makeDCElement(element, "ISO639-2", value, metadata);
                    } else {
                        this.makeDCElement(element, null, value, metadata);
                    }
                } else {
                    this.makeDCElement(element, null, value, metadata);
                }
            }
            if (allDC[i].element.equals("relation")) {
                if (allDC[i].qualifier != null) {
                    if (allDC[i].qualifier.equals("hasversion")) {
                        this.makeDCElement("hasVersion", null, value, metadata);
                    } else if (allDC[i].qualifier.equals("references") || allDC[i].qualifier.equals("requires")) {
                        this.makeDCTermsElement(qualifier, null, value, metadata);
                    } else {
                        this.makeDCElement(element, null, value, metadata);
                    }
                } else {
                    this.makeDCElement(element, null, value, metadata);
                }
            }
            if (allDC[i].element.equals("format")) {
                if (allDC[i].qualifier != null) {
                    if (allDC[i].qualifier.equals("extent")) {
                        this.makeDCTermsElement(qualifier, null, value, metadata);
                    } else if (allDC[i].qualifier.equals("mimetype")) {
                        this.makeDCElement(element, "IMT", value, metadata);
                    }
                } else {
                    this.makeDCElement(element, null, value, metadata);
                }
            }
            if (allDC[i].element.equals("identifier")) {
                if (allDC[i].qualifier != null) {
                    if (allDC[i].qualifier.equals("uri")) {
                        this.makeDCTermsElement("isReferencedBy", "URI", value, metadata);
                    } else if (allDC[i].qualifier.equals("citation")) {
                        this.makeDCTermsElement("hasVersion", null, value, metadata);
                    } else if (allDC[i].qualifier.equals("grantnumber")) {
                        this.makeUKDCTermsElement(qualifier, null, value, metadata);
                    }
                } else {
                    this.makeDCElement(element, null, value, metadata);
                }
            }
            if (!allDC[i].element.equals("rights")) continue;
            if (allDC[i].qualifier != null) {
                if (allDC[i].qualifier.equals("embargodate") || allDC[i].qualifier.equals("embargoreason")) {
                    this.makeUKDCTermsElement(qualifier, null, value, metadata);
                    continue;
                }
                this.makeDCElement(element, null, value, metadata);
                continue;
            }
            this.makeDCElement(element, null, value, metadata);
        }
        Bundle[] bundles = new Bundle[]{};
        try {
            bundles = item.getBundles("ORIGINAL");
            if (bundles.length > 0) {
                for (int i = 0; i < bundles.length; ++i) {
                    Bitstream[] bitstreams = bundles[i].getBitstreams();
                    for (int k = 0; k < bitstreams.length; ++k) {
                        if (bitstreams[k].getFormat().isInternal()) continue;
                        String url = ConfigurationManager.getProperty((String)"dspace.url") + "/bitstream/" + itemhandle + "/" + bitstreams[k].getSequenceID() + "/" + bitstreams[k].getName();
                        this.makeDCElement("identifier", "URI", url, metadata);
                        this.makeUKDCTermsElement("checksum", bitstreams[k].getChecksumAlgorithm(), bitstreams[k].getChecksum(), metadata);
                    }
                }
            }
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        return metadata.toString();
    }

    private StringBuffer makeDCElement(String element, String qualifier, String value, StringBuffer buffer) {
        return this.makeTermsElement(element, qualifier, value, buffer, "dc", "dcterms");
    }

    private StringBuffer makeDCTermsElement(String element, String qualifier, String value, StringBuffer buffer) {
        return this.makeTermsElement(element, qualifier, value, buffer, "dcterms", "dcterms");
    }

    private StringBuffer makeUKDCTermsElement(String element, String qualifier, String value, StringBuffer buffer) {
        return this.makeTermsElement(element, qualifier, value, buffer, "uketdterms", "uketdterms");
    }

    private StringBuffer makeTermsElement(String element, String qualifier, String value, StringBuffer buffer, String namespace, String terms) {
        if (value != null) {
            StringBuffer valueBuf = new StringBuffer(value.length());
            Matcher xmlMatcher = invalidXmlPattern.matcher(value.trim());
            while (xmlMatcher.find()) {
                String group = xmlMatcher.group();
                if ("&".equals(group)) {
                    xmlMatcher.appendReplacement(valueBuf, "&amp;");
                    continue;
                }
                if ("<".equals(group)) {
                    xmlMatcher.appendReplacement(valueBuf, "&lt;");
                    continue;
                }
                if (">".equals(group)) {
                    xmlMatcher.appendReplacement(valueBuf, "&gt;");
                    continue;
                }
                xmlMatcher.appendReplacement(valueBuf, " ");
            }
            xmlMatcher.appendTail(valueBuf);
            if (qualifier == null) {
                buffer.append("<").append(namespace).append(":").append(element).append(">").append(valueBuf.toString()).append("</").append(namespace).append(":").append(element).append(">\n");
            } else {
                buffer.append("<").append(namespace).append(":").append(element).append(" xsi:type=\"").append(terms).append(":").append(qualifier).append("\">").append(valueBuf.toString()).append("</").append(namespace).append(":").append(element).append(">\n");
            }
        } else {
            buffer.append("<").append(namespace).append(":").append(element).append(" />\n");
        }
        return buffer;
    }
}

