/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.oai;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.PluginManager;
import org.dspace.search.HarvestedItemInfo;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class METSCrosswalk
extends Crosswalk {
    private static final Logger log = Logger.getLogger(METSCrosswalk.class);
    private static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());

    public METSCrosswalk(Properties properties) {
        super("http://www.loc.gov/METS/ http://www.loc.gov/standards/mets/mets.xsd");
    }

    public boolean isAvailableFor(Object nativeItem) {
        return true;
    }

    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        HarvestedItemInfo hii = (HarvestedItemInfo)nativeItem;
        try {
            DisseminationCrosswalk xwalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, (String)"METS");
            if (xwalk == null) {
                throw new CannotDisseminateFormatException("DSpace cannot disseminate METS format, as no DisseminationCrosswalk is configured which supports 'METS'");
            }
            if (xwalk.canDisseminate((DSpaceObject)hii.item)) {
                Element rootElement = xwalk.disseminateElement((DSpaceObject)hii.item);
                return outputter.outputString(rootElement);
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)"OAI-PMH METSCrosswalk error", (Throwable)e);
            return null;
        }
    }
}

