/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.oai;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.PluginManager;
import org.dspace.search.HarvestedItemInfo;
import org.jdom.output.XMLOutputter;

public class PluginCrosswalk
extends Crosswalk {
    private static Logger log = Logger.getLogger(PluginCrosswalk.class);
    private DisseminationCrosswalk xwalk = null;
    private String schemaLabel = null;
    private static XMLOutputter outputUgly = new XMLOutputter();

    private static String makeSchemaLocation(String schemaLabel) {
        DisseminationCrosswalk xwalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, (String)schemaLabel);
        if (xwalk != null) {
            String schemaLoc = xwalk.getSchemaLocation();
            if (schemaLoc != null) {
                log.debug((Object)("Initialized schemaLabel=" + schemaLabel + " with schemaLocation = \"" + schemaLoc + "\""));
                return schemaLoc;
            }
            log.error((Object)("makeSchemaLocation:  crosswalk cannot provide schemaLocation, label=" + schemaLabel));
            return "Error No-schemaLocation-for-" + schemaLabel;
        }
        log.error((Object)("No crosswalk found, makeSchemaLocation giving up, label=" + schemaLabel));
        return "Error No-crosswalk-for-" + schemaLabel;
    }

    public PluginCrosswalk(String schemaLabel, Properties properties) {
        super(PluginCrosswalk.makeSchemaLocation(schemaLabel));
        this.xwalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, (String)schemaLabel);
        this.schemaLabel = schemaLabel;
    }

    public boolean isAvailableFor(Object nativeItem) {
        Item item = ((HarvestedItemInfo)nativeItem).item;
        return this.xwalk.canDisseminate((DSpaceObject)item);
    }

    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        Item item = ((HarvestedItemInfo)nativeItem).item;
        try {
            log.debug((Object)("OAI plugin, schema=" + this.schemaLabel + ", preferList=" + String.valueOf(this.xwalk.preferList())));
            if (this.xwalk.preferList()) {
                return outputUgly.outputString(this.xwalk.disseminateList((DSpaceObject)item));
            }
            return outputUgly.outputString(this.xwalk.disseminateElement((DSpaceObject)item));
        }
        catch (Exception e) {
            log.error((Object)(((Object)((Object)this)).getClass().getName() + ": hiding exception in CannotDisseminateFormatException:" + e.toString()));
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            log.error((Object)"*** Stack trace follows:");
            log.error((Object)sw.toString());
            throw new CannotDisseminateFormatException(this.schemaLabel);
        }
    }
}

