/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai;

import com.lyncode.xoai.dataprovider.OAIDataProvider;
import com.lyncode.xoai.dataprovider.OAIRequestParameters;
import com.lyncode.xoai.dataprovider.core.XOAIManager;
import com.lyncode.xoai.dataprovider.data.AbstractIdentify;
import com.lyncode.xoai.dataprovider.data.AbstractItemRepository;
import com.lyncode.xoai.dataprovider.data.AbstractSetRepository;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.exceptions.InvalidContextException;
import com.lyncode.xoai.dataprovider.filter.AbstractFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.xoai.data.DSpaceIdentify;
import org.dspace.xoai.data.DSpaceItemDatabaseRepository;
import org.dspace.xoai.data.DSpaceItemRepository;
import org.dspace.xoai.data.DSpaceItemSolrRepository;
import org.dspace.xoai.data.DSpaceSetRepository;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.solr.DSpaceSolrServer;
import org.dspace.xoai.util.XOAICacheManager;

public class DSpaceOAIDataProvider
extends HttpServlet {
    private static Logger log = LogManager.getLogger(DSpaceOAIDataProvider.class);

    public void init() {
        try {
            XOAIManager.initialize((String)ConfigurationManager.getProperty((String)"oai", (String)"config.dir"));
            if (!"database".equals(ConfigurationManager.getProperty((String)"oai", (String)"storage"))) {
                DSpaceSolrServer.getServer();
            }
            System.out.println("[OAI 2.0] Initialized");
        }
        catch (ConfigurationException e) {
            System.out.println("Unable to configure XOAI (XOAI 2.0 Core)");
            e.printStackTrace();
        }
        catch (SolrServerException e) {
            System.out.println("Unable to connect to Solr Server");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Unable to initialize XOAI.");
            e.printStackTrace();
        }
    }

    public void destroy() {
        System.out.println("[OAI 2.0] Destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        Context context = null;
        try {
            DSpaceItemRepository repository;
            log.debug((Object)"OAI 2.0 request received");
            context = new Context();
            if (XOAIManager.getManager() == null) {
                throw new ServletException("OAI 2.0 wasn't correctly initialized, please check the log for previous errors");
            }
            for (AbstractFilter filter : XOAIManager.getManager().getFilterManager().getFilters()) {
                if (!(filter instanceof DSpaceFilter)) continue;
                ((DSpaceFilter)filter).initialize(context);
            }
            String storage = ConfigurationManager.getProperty((String)"oai", (String)"storage");
            if (storage == null || !storage.trim().toLowerCase().equals("database")) {
                log.debug((Object)"Using Solr for querying");
                repository = new DSpaceItemSolrRepository();
            } else {
                log.debug((Object)"Using Database for querying");
                repository = new DSpaceItemDatabaseRepository(context);
            }
            log.debug((Object)"Creating OAI Data Provider Instance");
            OAIDataProvider dataProvider = new OAIDataProvider(request.getPathInfo().replace("/", ""), (AbstractIdentify)new DSpaceIdentify(context, request), (AbstractSetRepository)new DSpaceSetRepository(context), (AbstractItemRepository)repository);
            log.debug((Object)"Reading parameters from request");
            ServletOutputStream out = response.getOutputStream();
            OAIRequestParameters parameters = new OAIRequestParameters(this.buildParametersMap(request));
            response.setContentType("application/xml");
            String identification = request.getPathInfo().replace("/", "") + parameters.requestID();
            log.debug((Object)"Handling OAI request");
            XOAICacheManager.handle(identification, dataProvider, parameters, (OutputStream)out);
            out.flush();
            out.close();
            if (context != null) {
                context.abort();
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(500);
        }
        catch (InvalidContextException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            if (context != null) {
                context.abort();
            }
            response.sendError(404, "Requested OAI context \"" + request.getPathInfo().replace("/", "") + "\" does not exist");
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    private Map<String, List<String>> buildParametersMap(HttpServletRequest request) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            map.put(name, Arrays.asList(values));
        }
        return map;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

