/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.app;

import com.lyncode.xoai.dataprovider.exceptions.MetadataBindException;
import com.lyncode.xoai.dataprovider.util.MarshallingUtils;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xoai.data.DSpaceDatabaseItem;
import org.dspace.xoai.exceptions.CompilingException;
import org.dspace.xoai.solr.DSpaceSolrSearch;
import org.dspace.xoai.solr.DSpaceSolrServer;
import org.dspace.xoai.solr.exceptions.DSpaceSolrException;
import org.dspace.xoai.solr.exceptions.DSpaceSolrIndexerException;
import org.dspace.xoai.util.DateUtils;
import org.dspace.xoai.util.ItemUtils;
import org.dspace.xoai.util.XOAICacheManager;
import org.dspace.xoai.util.XOAIDatabaseManager;

public class XOAI {
    private static Logger log = LogManager.getLogger(XOAI.class);
    private Context _context;
    private boolean _optimize;
    private boolean _verbose;
    private boolean _clean;
    private static final String COMMAND_IMPORT = "import";
    private static final String COMMAND_CLEAN_CACHE = "clean-cache";
    private static final String COMMAND_COMPILE_ITEMS = "compile-items";
    private static final String COMMAND_ERASE_COMPILED_ITEMS = "erase-compiled-items";

    private static List<String> getFileFormats(Item item) {
        ArrayList<String> formats = new ArrayList<String>();
        try {
            for (Bundle b : item.getBundles("ORIGINAL")) {
                for (Bitstream bs : b.getBitstreams()) {
                    if (formats.contains(bs.getFormat().getMIMEType())) continue;
                    formats.add(bs.getFormat().getMIMEType());
                }
            }
        }
        catch (SQLException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return formats;
    }

    public XOAI(Context context, boolean optimize, boolean clean, boolean verbose) {
        this._context = context;
        this._optimize = optimize;
        this._clean = clean;
        this._verbose = verbose;
    }

    public XOAI(Context ctx, boolean hasOption) {
        this._context = ctx;
        this._verbose = hasOption;
    }

    private void println(String line) {
        System.out.println(line);
    }

    public int index() throws DSpaceSolrIndexerException {
        int result = 0;
        try {
            if (this._clean) {
                XOAI.clearIndex();
                System.out.println("Using full import.");
                this.indexAll();
            } else {
                SolrQuery solrParams = new SolrQuery("*:*").addField("item.lastmodified").addSortField("item.lastmodified", SolrQuery.ORDER.desc).setRows(Integer.valueOf(1));
                SolrDocumentList results = DSpaceSolrSearch.query(solrParams);
                if (results.getNumFound() == 0L) {
                    System.out.println("There are no indexed documents, using full import.");
                    result = this.indexAll();
                } else {
                    result = this.index((java.util.Date)((SolrDocument)results.get(0)).getFieldValue("item.lastmodified"));
                }
            }
            DSpaceSolrServer.getServer().commit();
            if (this._optimize) {
                this.println("Optimizing Index");
                DSpaceSolrServer.getServer().optimize();
                this.println("Index optimized");
            }
            XOAICacheManager.setLastCompilationDate(new java.util.Date());
            return result;
        }
        catch (DSpaceSolrException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
        catch (SolrServerException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private int index(java.util.Date last) throws DSpaceSolrIndexerException {
        System.out.println("Incremental import. Searching for documents modified after: " + last.toString());
        String sqlQuery = "SELECT item_id FROM item WHERE in_archive=TRUE AND last_modified > ?";
        if (DatabaseManager.isOracle()) {
            sqlQuery = "SELECT item_id FROM item WHERE in_archive=1 AND last_modified > ?";
        }
        try {
            TableRowIterator iterator = DatabaseManager.query((Context)this._context, (String)sqlQuery, (Object[])new Object[]{new Timestamp(last.getTime())});
            return this.index(iterator);
        }
        catch (SQLException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private int indexAll() throws DSpaceSolrIndexerException {
        System.out.println("Full import");
        try {
            String sqlQuery = "SELECT item_id FROM item WHERE in_archive=TRUE";
            if (DatabaseManager.isOracle()) {
                sqlQuery = "SELECT item_id FROM item WHERE in_archive=1";
            }
            TableRowIterator iterator = DatabaseManager.query((Context)this._context, (String)sqlQuery, (Object[])new Object[0]);
            return this.index(iterator);
        }
        catch (SQLException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private int index(TableRowIterator iterator) throws DSpaceSolrIndexerException {
        try {
            int i = 0;
            SolrServer server = DSpaceSolrServer.getServer();
            while (iterator.hasNext()) {
                try {
                    server.add(this.index(Item.find((Context)this._context, (int)iterator.next().getIntColumn("item_id"))));
                    this._context.clearCache();
                }
                catch (SQLException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (MetadataBindException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (ParseException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if (++i % 100 != 0) continue;
                System.out.println(i + " items imported so far...");
            }
            System.out.println("Total: " + i + " items");
            server.commit();
            return i;
        }
        catch (SQLException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
        catch (SolrServerException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private SolrInputDocument index(Item item) throws SQLException, MetadataBindException, ParseException {
        DCValue[] allData;
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("item.id", (Object)item.getID());
        boolean pub = this.isPublic(item);
        doc.addField("item.public", (Object)pub);
        String handle = item.getHandle();
        doc.addField("item.handle", (Object)handle);
        doc.addField("item.lastmodified", (Object)DateUtils.toSolrDate(item.getLastModified()));
        doc.addField("item.submitter", (Object)item.getSubmitter().getEmail());
        doc.addField("item.deleted", (Object)(item.isWithdrawn() ? "true" : "false"));
        for (Collection col : item.getCollections()) {
            doc.addField("item.collections", (Object)("col_" + col.getHandle().replace("/", "_")));
        }
        for (Community com : XOAIDatabaseManager.flatParentCommunities(item)) {
            doc.addField("item.communities", (Object)("com_" + com.getHandle().replace("/", "_")));
        }
        for (DCValue dc : allData = item.getMetadata("*", "*", "*", "*")) {
            String key = "metadata." + dc.schema + "." + dc.element;
            if (dc.qualifier != null) {
                key = key + "." + dc.qualifier;
            }
            doc.addField(key, (Object)dc.value);
            if (dc.authority == null) continue;
            doc.addField(key + ".authority", (Object)dc.authority);
            doc.addField(key + ".confidence", (Object)(dc.confidence + ""));
        }
        for (String f : XOAI.getFileFormats(item)) {
            doc.addField("metadata.dc.format.mimetype", (Object)f);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MarshallingUtils.writeMetadata((OutputStream)out, (Metadata)ItemUtils.retrieveMetadata(item));
        doc.addField("item.compile", (Object)out.toString());
        if (this._verbose) {
            this.println("Item with handle " + handle + " indexed");
        }
        return doc;
    }

    private boolean isPublic(Item item) {
        try {
            AuthorizeManager.authorizeAction((Context)this._context, (DSpaceObject)item, (int)0);
            for (Bundle b : item.getBundles()) {
                AuthorizeManager.authorizeAction((Context)this._context, (DSpaceObject)b, (int)0);
            }
            return true;
        }
        catch (AuthorizeException ex) {
            log.debug((Object)ex.getMessage());
        }
        catch (SQLException ex) {
            log.error((Object)ex.getMessage());
        }
        return false;
    }

    private static boolean getKnownExplanation(Throwable t) {
        if (t instanceof ConnectException) {
            System.err.println("Solr server (" + ConfigurationManager.getProperty((String)"oai", (String)"solr.url") + ") is down, turn it on.");
            return true;
        }
        return false;
    }

    private static boolean searchForReason(Throwable t) {
        if (XOAI.getKnownExplanation(t)) {
            return true;
        }
        if (t.getCause() != null) {
            return XOAI.searchForReason(t.getCause());
        }
        return false;
    }

    private static void clearIndex() throws DSpaceSolrIndexerException {
        try {
            System.out.println("Clearing index");
            DSpaceSolrServer.getServer().deleteByQuery("*:*");
            DSpaceSolrServer.getServer().commit();
            System.out.println("Index cleared");
        }
        catch (SolrServerException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private static void cleanCache() {
        System.out.println("Purging cached OAI responses.");
        XOAICacheManager.deleteCachedResponses();
    }

    public static void main(String[] argv) {
        try {
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("c", "clear", false, "Clear index before indexing");
            options.addOption("o", "optimize", false, "Optimize index at the end");
            options.addOption("v", "verbose", false, "Verbose output");
            options.addOption("h", "help", false, "Shows some help");
            options.addOption("n", "number", true, "FOR DEVELOPMENT MUST DELETE");
            CommandLine line = parser.parse(options, argv);
            String[] validSolrCommands = new String[]{COMMAND_IMPORT, COMMAND_CLEAN_CACHE};
            String[] validDatabaseCommands = new String[]{COMMAND_CLEAN_CACHE, COMMAND_COMPILE_ITEMS, COMMAND_ERASE_COMPILED_ITEMS};
            boolean solr = true;
            solr = !"database".equals(ConfigurationManager.getProperty((String)"oai", (String)"storage"));
            boolean run = false;
            if (line.getArgs().length > 0) {
                if (solr) {
                    if (Arrays.asList(validSolrCommands).contains(line.getArgs()[0])) {
                        run = true;
                    }
                } else if (Arrays.asList(validDatabaseCommands).contains(line.getArgs()[0])) {
                    run = true;
                }
            }
            if (!line.hasOption('h') && run) {
                System.out.println("OAI 2.0 manager action started");
                long start = System.currentTimeMillis();
                String command = line.getArgs()[0];
                if (COMMAND_IMPORT.equals(command)) {
                    Context ctx = new Context();
                    XOAI indexer = new XOAI(ctx, line.hasOption('o'), line.hasOption('c'), line.hasOption('v'));
                    int imported = indexer.index();
                    if (imported > 0) {
                        XOAI.cleanCache();
                    }
                    ctx.abort();
                } else if (COMMAND_CLEAN_CACHE.equals(command)) {
                    XOAI.cleanCache();
                } else if (COMMAND_COMPILE_ITEMS.equals(command)) {
                    Context ctx = new Context();
                    XOAI indexer = new XOAI(ctx, line.hasOption('v'));
                    indexer.compile();
                    XOAI.cleanCache();
                    ctx.abort();
                } else if (COMMAND_ERASE_COMPILED_ITEMS.equals(command)) {
                    XOAI.cleanCompiledItems();
                    XOAI.cleanCache();
                }
                System.out.println("OAI 2.0 manager action ended. It took " + (System.currentTimeMillis() - start) / 1000L + " seconds.");
            } else {
                XOAI.usage();
            }
        }
        catch (Throwable ex) {
            if (!XOAI.searchForReason(ex)) {
                ex.printStackTrace();
            }
            log.error((Object)ex.getMessage(), ex);
        }
    }

    private static void cleanCompiledItems() {
        System.out.println("Purging compiled items");
        XOAICacheManager.deleteCompiledItems();
    }

    private void compile() throws CompilingException {
        try {
            ItemIterator iterator;
            java.util.Date last = XOAICacheManager.getLastCompilationDate();
            if (last == null) {
                System.out.println("Retrieving all items to be compiled");
                iterator = Item.findAll((Context)this._context);
            } else {
                System.out.println("Retrieving items modified after " + last + " to be compiled");
                String query = "SELECT * FROM item WHERE last_modified>?";
                iterator = new ItemIterator(this._context, DatabaseManager.query((Context)this._context, (String)query, (Object[])new Object[]{new Date(last.getTime())}));
            }
            while (iterator.hasNext()) {
                Item item = iterator.next();
                if (this._verbose) {
                    System.out.println("Compiling item with handle: " + item.getHandle());
                }
                XOAICacheManager.compileItem(new DSpaceDatabaseItem(item));
                this._context.clearCache();
            }
            XOAICacheManager.setLastCompilationDate(new java.util.Date());
        }
        catch (SQLException e) {
            throw new CompilingException(e);
        }
        System.out.println("Items compiled");
    }

    private static void usage() {
        boolean solr = true;
        boolean bl = solr = !"database".equals(ConfigurationManager.getProperty((String)"oai", (String)"storage"));
        if (solr) {
            System.out.println("OAI Manager Script");
            System.out.println("Syntax: oai <action> [parameters]");
            System.out.println("> Possible actions:");
            System.out.println("     import - To import DSpace items into OAI index and cache system");
            System.out.println("     clean-cache - Cleans the OAI cached responses");
            System.out.println("> Parameters:");
            System.out.println("     -o Optimize index after indexing (import only)");
            System.out.println("     -c Clear index (import only)");
            System.out.println("     -v Verbose output");
            System.out.println("     -h Shows this text");
        } else {
            System.out.println("OAI Manager Script");
            System.out.println("Syntax: oai <action> [parameters]");
            System.out.println("> Possible actions:");
            System.out.println("     clean-cache - Cleans the OAI cached responses");
            System.out.println("     compile-items - Compiles all DSpace items");
            System.out.println("     erase-compiled-items - Erase the OAI compiled items");
            System.out.println("> Parameters:");
            System.out.println("     -v Verbose output");
            System.out.println("     -h Shows this text");
        }
    }
}

