/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.data;

import com.lyncode.xoai.dataprovider.core.ItemMetadata;
import com.lyncode.xoai.dataprovider.core.ReferenceSet;
import com.lyncode.xoai.dataprovider.data.AbstractAbout;
import com.lyncode.xoai.dataprovider.exceptions.MetadataBindException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.data.DSpaceSet;
import org.dspace.xoai.util.XOAICacheManager;
import org.dspace.xoai.util.XOAIDatabaseManager;

public class DSpaceDatabaseItem
extends DSpaceItem {
    private static Logger log = LogManager.getLogger(DSpaceDatabaseItem.class);
    private Item item;
    private List<ReferenceSet> sets;
    private ItemMetadata metadata = null;

    private static List<ReferenceSet> getSets(Item item) {
        ArrayList<ReferenceSet> sets = new ArrayList<ReferenceSet>();
        ArrayList<Community> coms = new ArrayList<Community>();
        try {
            Collection[] itemCollections;
            for (Collection col : itemCollections = item.getCollections()) {
                DSpaceSet s = new DSpaceSet(col);
                sets.add((ReferenceSet)s);
                for (Community com : XOAIDatabaseManager.flatParentCommunities(col)) {
                    if (coms.contains(com)) continue;
                    coms.add(com);
                }
            }
            for (Community com : coms) {
                DSpaceSet s = new DSpaceSet(com);
                sets.add((ReferenceSet)s);
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sets;
    }

    public DSpaceDatabaseItem(Item item) {
        this.item = item;
        this.sets = DSpaceDatabaseItem.getSets(item);
    }

    @Override
    public List<AbstractAbout> getAbout() {
        return new ArrayList<AbstractAbout>();
    }

    public Date getDatestamp() {
        return this.item.getLastModified();
    }

    public List<ReferenceSet> getSets() {
        return this.sets;
    }

    public boolean isDeleted() {
        return this.item.isWithdrawn();
    }

    public ItemMetadata getMetadata() {
        if (this.metadata == null) {
            try {
                this.metadata = new ItemMetadata(XOAICacheManager.getCompiledMetadata(this));
            }
            catch (MetadataBindException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                this.metadata = new ItemMetadata(XOAICacheManager.getMetadata(this));
            }
        }
        return this.metadata;
    }

    public Item getItem() {
        return this.item;
    }

    @Override
    protected String getHandle() {
        return this.item.getHandle();
    }
}

