/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.data;

import com.lyncode.xoai.dataprovider.core.DeleteMethod;
import com.lyncode.xoai.dataprovider.core.Granularity;
import com.lyncode.xoai.dataprovider.data.AbstractIdentify;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xoai.exceptions.InvalidMetadataFieldException;
import org.dspace.xoai.util.DateUtils;
import org.dspace.xoai.util.MetadataFieldManager;

public class DSpaceIdentify
extends AbstractIdentify {
    private static Logger log = LogManager.getLogger(DSpaceIdentify.class);
    private static List<String> _emails = null;
    private static String _name = null;
    private static String _baseUrl = null;
    private Context _context;
    private HttpServletRequest _request;

    public DSpaceIdentify(Context context, HttpServletRequest request) {
        this._context = context;
        this._request = request;
    }

    public List<String> getAdminEmails() {
        if (_emails == null) {
            _emails = new ArrayList<String>();
            String result = ConfigurationManager.getProperty((String)"mail.admin");
            if (result == null) {
                log.warn((Object)"{ OAI 2.0 :: DSpace } Not able to retrieve the mail.admin property from the configuration file");
            } else {
                _emails.add(result);
            }
        }
        return _emails;
    }

    public String getBaseUrl() {
        if (_baseUrl == null) {
            _baseUrl = this._request.getRequestURL().toString().replace(this._request.getPathInfo(), "");
        }
        return _baseUrl + this._request.getPathInfo();
    }

    public DeleteMethod getDeleteMethod() {
        return DeleteMethod.PERSISTENT;
    }

    public Date getEarliestDate() {
        block8: {
            try {
                TableRowIterator iterator;
                String query = "SELECT MIN(text_value) as value FROM metadatavalue WHERE metadata_field_id = ?";
                String db = ConfigurationManager.getProperty((String)"db.name");
                boolean postgres = true;
                if ("oracle".equals(db)) {
                    postgres = false;
                }
                if (!postgres) {
                    query = "SELECT MIN(TO_CHAR(text_value)) as value FROM metadatavalue WHERE metadata_field_id = ?";
                }
                if (!(iterator = DatabaseManager.query((Context)this._context, (String)query, (Object[])new Object[]{MetadataFieldManager.getFieldID(this._context, "dc.date.available")})).hasNext()) break block8;
                String str = iterator.next().getStringColumn("value");
                try {
                    Date d = DateUtils.parseDate(str);
                    if (d != null) {
                        return d;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvalidMetadataFieldException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new Date();
    }

    public Granularity getGranularity() {
        return Granularity.Second;
    }

    public String getRepositoryName() {
        if (_name == null && (_name = ConfigurationManager.getProperty((String)"dspace.name")) == null) {
            log.warn((Object)"{ OAI 2.0 :: DSpace } Not able to retrieve the dspace.name property from the configuration file");
            _name = "OAI Repository";
        }
        return _name;
    }

    public List<String> getDescription() {
        ArrayList<String> result = new ArrayList<String>();
        String descriptionFile = ConfigurationManager.getProperty((String)"oai", (String)"description.file");
        if (descriptionFile == null) {
            boolean stop = false;
            ArrayList<String> descriptionFiles = new ArrayList<String>();
            int i = 0;
            while (!stop) {
                String tmp = ConfigurationManager.getProperty((String)"oai", (String)("description.file." + i));
                if (tmp == null && i != 0) {
                    stop = true;
                } else {
                    descriptionFiles.add(tmp);
                }
                ++i;
            }
            for (String path : descriptionFiles) {
                try {
                    result.add(FileUtils.readFileToString((File)new File(path)));
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else {
            try {
                result.add(FileUtils.readFileToString((File)new File(descriptionFile)));
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

