/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.data;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.lyncode.xoai.dataprovider.data.AbstractAbout;
import com.lyncode.xoai.dataprovider.data.AbstractItem;
import com.lyncode.xoai.dataprovider.xml.xoai.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dspace.core.ConfigurationManager;
import org.dspace.xoai.util.MetadataNamePredicate;

public abstract class DSpaceItem
extends AbstractItem {
    private static String _prefix = null;

    private static List<Element> filter(List<Element> input, String name) {
        return Lists.newArrayList((Iterable)Collections2.filter(input, (Predicate)new MetadataNamePredicate(name)));
    }

    private static List<Element> flat(List<Element> input) {
        ArrayList<Element> elems = new ArrayList<Element>();
        for (Element e : input) {
            if (e.getElement() == null) continue;
            elems.addAll(e.getElement());
        }
        return elems;
    }

    private static List<String> values(List<Element> input) {
        ArrayList<String> elems = new ArrayList<String>();
        for (Element e : input) {
            if (e.getElement() == null || e.getElement().isEmpty() || ((Element)e.getElement().get(0)).getField() == null) continue;
            for (Element.Field f : ((Element)e.getElement().get(0)).getField()) {
                if (f.getName() == null || !f.getName().equals("value")) continue;
                elems.add(f.getValue());
            }
        }
        return elems;
    }

    private List<String> getMetadata(String schema, String element) {
        List metadata = this.getMetadata().getMetadata().getElement();
        return DSpaceItem.values(DSpaceItem.filter(DSpaceItem.flat(DSpaceItem.filter(metadata, schema)), element));
    }

    private List<String> getMetadata(String schema, String element, String qualifier) {
        List metadata = this.getMetadata().getMetadata().getElement();
        return DSpaceItem.values(DSpaceItem.filter(DSpaceItem.flat(DSpaceItem.filter(DSpaceItem.flat(DSpaceItem.filter(metadata, schema)), element)), qualifier));
    }

    public static String buildIdentifier(String handle) {
        if (_prefix == null) {
            _prefix = ConfigurationManager.getProperty((String)"oai", (String)"identifier.prefix");
        }
        return "oai:" + _prefix + ":" + handle;
    }

    public static String parseHandle(String oaiIdentifier) {
        String[] parts = oaiIdentifier.split(Pattern.quote(":"));
        if (parts.length > 0) {
            return parts[parts.length - 1];
        }
        return null;
    }

    public List<String> getMetadata(String field) {
        String[] parts = field.split(Pattern.quote("."));
        if (parts.length == 2) {
            return this.getMetadata(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return this.getMetadata(parts[0], parts[1], parts[2]);
        }
        return new ArrayList<String>();
    }

    public List<AbstractAbout> getAbout() {
        return new ArrayList<AbstractAbout>();
    }

    protected abstract String getHandle();

    public String getIdentifier() {
        return DSpaceItem.buildIdentifier(this.getHandle());
    }
}

