/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.data;

import com.lyncode.xoai.dataprovider.core.ListItemIdentifiersResult;
import com.lyncode.xoai.dataprovider.core.ListItemsResults;
import com.lyncode.xoai.dataprovider.data.AbstractItem;
import com.lyncode.xoai.dataprovider.exceptions.IdDoesNotExistException;
import com.lyncode.xoai.dataprovider.filter.Filter;
import com.lyncode.xoai.dataprovider.filter.FilterScope;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.dspace.xoai.data.DSpaceItemRepository;
import org.dspace.xoai.data.DSpaceSolrItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.SolrFilterResult;
import org.dspace.xoai.solr.DSpaceSolrSearch;
import org.dspace.xoai.solr.exceptions.DSpaceSolrException;
import org.dspace.xoai.solr.exceptions.SolrSearchEmptyException;

public class DSpaceItemSolrRepository
extends DSpaceItemRepository {
    private static Logger log = LogManager.getLogger(DSpaceItemSolrRepository.class);

    public AbstractItem getItem(String identifier) throws IdDoesNotExistException {
        String[] parts = identifier.split(Pattern.quote(":"));
        if (parts.length == 3) {
            try {
                SolrQuery params = new SolrQuery("item.handle:" + parts[2]);
                return new DSpaceSolrItem(DSpaceSolrSearch.querySingle(params));
            }
            catch (SolrSearchEmptyException ex) {
                throw new IdDoesNotExistException((Exception)ex);
            }
        }
        throw new IdDoesNotExistException();
    }

    public ListItemIdentifiersResult getItemIdentifiers(List<Filter> filters, int offset, int length) {
        ArrayList<String> whereCond = new ArrayList<String>();
        for (Filter filter : filters) {
            DSpaceFilter dspaceFilter;
            SolrFilterResult result;
            if (!(filter.getFilter() instanceof DSpaceFilter) || !(result = (dspaceFilter = (DSpaceFilter)filter.getFilter()).getQuery()).hasResult()) continue;
            if (filter.getScope() == FilterScope.MetadataFormat) {
                whereCond.add("(item.deleted:true OR (" + result.getQuery() + "))");
                continue;
            }
            whereCond.add("(" + result.getQuery() + ")");
        }
        if (whereCond.isEmpty()) {
            whereCond.add("*:*");
        }
        String where = "(" + StringUtils.join(whereCond.iterator(), (String)") AND (") + ")";
        return this.getIdentifierResult(where, offset, length);
    }

    public ListItemsResults getItems(List<Filter> filters, int offset, int length) {
        ArrayList<String> whereCond = new ArrayList<String>();
        for (Filter filter : filters) {
            DSpaceFilter dspaceFilter;
            SolrFilterResult result;
            if (!(filter.getFilter() instanceof DSpaceFilter) || !(result = (dspaceFilter = (DSpaceFilter)filter.getFilter()).getQuery()).hasResult()) continue;
            if (filter.getScope() == FilterScope.MetadataFormat) {
                whereCond.add("(item.deleted:true OR (" + result.getQuery() + "))");
                continue;
            }
            whereCond.add("(" + result.getQuery() + ")");
        }
        if (whereCond.isEmpty()) {
            whereCond.add("*:*");
        }
        String where = "(" + StringUtils.join(whereCond.iterator(), (String)") AND (") + ")";
        return this.getResult(where, offset, length);
    }

    private ListItemsResults getResult(String where, int offset, int length) {
        ArrayList<DSpaceSolrItem> list = new ArrayList<DSpaceSolrItem>();
        try {
            SolrQuery params = new SolrQuery(where).setRows(Integer.valueOf(length)).setStart(Integer.valueOf(offset));
            SolrDocumentList docs = DSpaceSolrSearch.query(params);
            for (SolrDocument doc : docs) {
                list.add(new DSpaceSolrItem(doc));
            }
            return new ListItemsResults(docs.getNumFound() > (long)(offset + length), list, (int)docs.getNumFound());
        }
        catch (DSpaceSolrException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return new ListItemsResults(false, list);
        }
    }

    private ListItemIdentifiersResult getIdentifierResult(String where, int offset, int length) {
        ArrayList<DSpaceSolrItem> list = new ArrayList<DSpaceSolrItem>();
        try {
            SolrQuery params = new SolrQuery(where).setRows(Integer.valueOf(length)).setStart(Integer.valueOf(offset));
            boolean hasMore = false;
            SolrDocumentList docs = DSpaceSolrSearch.query(params);
            hasMore = (long)(offset + length) < docs.getNumFound();
            for (SolrDocument doc : docs) {
                list.add(new DSpaceSolrItem(doc));
            }
            return new ListItemIdentifiersResult(hasMore, list, (int)docs.getNumFound());
        }
        catch (DSpaceSolrException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return new ListItemIdentifiersResult(false, list);
        }
    }
}

