/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.data;

import com.lyncode.xoai.dataprovider.core.ListSetsResult;
import com.lyncode.xoai.dataprovider.core.Set;
import com.lyncode.xoai.dataprovider.data.AbstractSetRepository;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xoai.data.DSpaceSet;

public class DSpaceSetRepository
extends AbstractSetRepository {
    private static Logger log = LogManager.getLogger(DSpaceSetRepository.class);
    private Context _context;

    public DSpaceSetRepository(Context context) {
        this._context = context;
    }

    private int getCommunityCount() {
        String query = "SELECT COUNT(*) as count FROM community";
        try {
            TableRowIterator iterator = DatabaseManager.query((Context)this._context, (String)query, (Object[])new Object[0]);
            if (iterator.hasNext()) {
                return (int)iterator.next().getLongColumn("count");
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private int getCollectionCount() {
        String query = "SELECT COUNT(*) as count FROM collection";
        try {
            TableRowIterator iterator = DatabaseManager.query((Context)this._context, (String)query, (Object[])new Object[0]);
            if (iterator.hasNext()) {
                return (int)iterator.next().getLongColumn("count");
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    private List<Set> community(int offset, int length) {
        ArrayList<Set> array = new ArrayList<Set>();
        StringBuffer query = new StringBuffer("SELECT community_id, name, handle FROM community c, handle h WHERE h.resource_id=community_id AND h.resource_type_id=? ORDER BY community_id");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(4);
        DatabaseManager.applyOffsetAndLimit((StringBuffer)query, params, (int)offset, (int)length);
        try {
            TableRowIterator iterator = DatabaseManager.query((Context)this._context, (String)query.toString(), (Object[])params.toArray());
            for (int i = 0; iterator.hasNext() && i < length; ++i) {
                TableRow row = iterator.next();
                array.add(DSpaceSet.newDSpaceCommunitySet(row.getStringColumn("handle"), row.getStringColumn("name")));
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return array;
    }

    private List<Set> collection(int offset, int length) {
        ArrayList<Set> array = new ArrayList<Set>();
        StringBuffer query = new StringBuffer("SELECT collection_id, name, handle FROM collection c, handle h WHERE h.resource_id=collection_id AND h.resource_type_id=? ORDER BY collection_id");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(3);
        DatabaseManager.applyOffsetAndLimit((StringBuffer)query, params, (int)offset, (int)length);
        try {
            TableRowIterator iterator = DatabaseManager.query((Context)this._context, (String)query.toString(), (Object[])params.toArray());
            for (int i = 0; iterator.hasNext() && i < length; ++i) {
                TableRow row = iterator.next();
                array.add(DSpaceSet.newDSpaceCollectionSet(row.getStringColumn("handle"), row.getStringColumn("name")));
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return array;
    }

    public ListSetsResult retrieveSets(int offset, int length) {
        log.debug((Object)("Quering sets. Offset: " + offset + " - Length: " + length));
        ArrayList<Set> array = new ArrayList<Set>();
        int communityCount = this.getCommunityCount();
        log.debug((Object)("Communities: " + communityCount));
        int collectionCount = this.getCollectionCount();
        log.debug((Object)("Collections: " + collectionCount));
        if (offset < communityCount) {
            if (offset + length > communityCount) {
                List<Set> tmp = this.community(offset, length);
                array.addAll(tmp);
                array.addAll(this.collection(0, length - tmp.size()));
            } else {
                array.addAll(this.community(offset, length));
            }
        } else if (offset < communityCount + collectionCount) {
            array.addAll(this.collection(offset - communityCount, length));
        }
        log.debug((Object)("Has More Results: " + (offset + length < communityCount + collectionCount ? "Yes" : "No")));
        return new ListSetsResult(offset + length < communityCount + collectionCount, array, communityCount + collectionCount);
    }

    public boolean supportSets() {
        return true;
    }

    public boolean exists(String setSpec) {
        if (setSpec.startsWith("col_")) {
            try {
                DSpaceObject dso = HandleManager.resolveToObject((Context)this._context, (String)setSpec.replace("col_", "").replace("_", "/"));
                return dso != null && dso instanceof Collection;
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else if (setSpec.startsWith("com_")) {
            try {
                DSpaceObject dso = HandleManager.resolveToObject((Context)this._context, (String)setSpec.replace("com_", "").replace("_", "/"));
                return dso != null && dso instanceof Community;
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return false;
    }
}

