/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.DatabaseFilterResult;
import org.dspace.xoai.filter.SolrFilterResult;

public class DSpaceAuthorizationFilter
extends DSpaceFilter {
    private static Logger log = LogManager.getLogger(DSpaceAuthorizationFilter.class);

    @Override
    public DatabaseFilterResult getWhere(Context context) {
        ArrayList<Object> params = new ArrayList<Object>();
        return new DatabaseFilterResult("EXISTS (SELECT p.action_id FROM resourcepolicy p, bundle2bitstream b, bundle bu, item2bundle ib WHERE p.resource_type_id=0 AND p.resource_id=b.bitstream_id AND p.epersongroup_id=0 AND b.bundle_id=ib.bundle_id AND bu.bundle_id=b.bundle_id AND bu.name='ORIGINAL' AND ib.item_id=i.item_id)", params);
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        try {
            Context ctx = super.getContext();
            String handle = DSpaceItem.parseHandle(item.getIdentifier());
            if (handle == null) {
                return false;
            }
            Item dsitem = (Item)HandleManager.resolveToObject((Context)ctx, (String)handle);
            AuthorizeManager.authorizeAction((Context)ctx, (DSpaceObject)dsitem, (int)0);
            for (Bundle b : dsitem.getBundles()) {
                AuthorizeManager.authorizeAction((Context)ctx, (DSpaceObject)b, (int)0);
            }
            return true;
        }
        catch (AuthorizeException ex) {
            log.debug((Object)ex.getMessage());
        }
        catch (SQLException ex) {
            log.error((Object)ex.getMessage());
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage());
        }
        return false;
    }

    @Override
    public SolrFilterResult getQuery() {
        return new SolrFilterResult("item.public:true");
    }
}

