/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.exceptions.InvalidMetadataFieldException;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.DatabaseFilterResult;
import org.dspace.xoai.filter.SolrFilterResult;
import org.dspace.xoai.util.MetadataFieldManager;

public class DSpaceMetadataExistsFilter
extends DSpaceFilter {
    private static Logger log = LogManager.getLogger(DSpaceMetadataExistsFilter.class);
    private List<String> _fields;

    private List<String> getFields() {
        if (this._fields == null) {
            this._fields = super.getParameters("fields");
            if (this._fields.isEmpty()) {
                this._fields = super.getParameters("field");
            }
        }
        return this._fields;
    }

    @Override
    public DatabaseFilterResult getWhere(Context context) {
        try {
            List<String> fields = this.getFields();
            StringBuilder where = new StringBuilder();
            ArrayList<Object> args = new ArrayList<Object>(fields.size());
            where.append("(");
            for (int i = 0; i < fields.size(); ++i) {
                where.append("EXISTS (SELECT tmp.* FROM metadatavalue tmp WHERE tmp.item_id=i.item_id AND tmp.metadata_field_id=?)");
                args.add(MetadataFieldManager.getFieldID(context, fields.get(i)));
                if (i >= fields.size() - 1) continue;
                where.append(" OR ");
            }
            where.append(")");
            return new DatabaseFilterResult(where.toString(), args);
        }
        catch (InvalidMetadataFieldException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new DatabaseFilterResult();
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        for (String field : this.getFields()) {
            if (item.getMetadata(field).size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public SolrFilterResult getQuery() {
        StringBuilder cond = new StringBuilder("(");
        List<String> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            cond.append("metadata.").append(fields.get(i)).append(":[* TO *]");
            if (i >= fields.size() - 1) continue;
            cond.append(" OR ");
        }
        cond.append(")");
        return new SolrFilterResult(cond.toString());
    }
}

