/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import java.util.Date;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.core.Context;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.DatabaseFilterResult;
import org.dspace.xoai.filter.SolrFilterResult;
import org.dspace.xoai.util.DateUtils;

public class DateUntilFilter
extends DSpaceFilter {
    private Date _date;

    public DateUntilFilter(Date date) {
        this._date = date;
    }

    @Override
    public DatabaseFilterResult getWhere(Context context) {
        return new DatabaseFilterResult("i.last_modified <= ?", new java.sql.Date(this._date.getTime()));
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        return item.getDatestamp().compareTo(this._date) <= 0;
    }

    @Override
    public SolrFilterResult getQuery() {
        return new SolrFilterResult("item.lastmodified:[* TO " + ClientUtils.escapeQueryChars((String)DateUtils.formatToSolr(this._date, false)) + "]");
    }
}

