/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import com.lyncode.xoai.dataprovider.core.ReferenceSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.DatabaseFilterResult;
import org.dspace.xoai.filter.SolrFilterResult;
import org.dspace.xoai.util.XOAIDatabaseManager;

public class DspaceSetSpecFilter
extends DSpaceFilter {
    private static Logger log = LogManager.getLogger(DspaceSetSpecFilter.class);
    private String _setSpec;

    public DspaceSetSpecFilter(String spec) {
        this._setSpec = spec;
    }

    @Override
    public DatabaseFilterResult getWhere(Context context) {
        if (this._setSpec.startsWith("col_")) {
            try {
                DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)this._setSpec.replace("col_", ""));
                return new DatabaseFilterResult("EXISTS (SELECT tmp.* FROM collection2item tmp WHERE tmp.item_id=i.item_id AND collection_id = ?)", dso.getID());
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else if (this._setSpec.startsWith("com_")) {
            try {
                DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)this._setSpec.replace("com_", ""));
                List<Integer> list = XOAIDatabaseManager.getAllSubCollections(context, dso.getID());
                String subCollections = StringUtils.join(list.iterator(), (String)",");
                return new DatabaseFilterResult("EXISTS (SELECT tmp.* FROM collection2item tmp WHERE tmp.item_id=i.item_id AND collection_id IN (" + subCollections + "))", new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new DatabaseFilterResult();
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        for (ReferenceSet s : item.getSets()) {
            if (!s.getSetSpec().equals(this._setSpec)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SolrFilterResult getQuery() {
        if (this._setSpec.startsWith("col_")) {
            try {
                return new SolrFilterResult("item.collections:" + ClientUtils.escapeQueryChars((String)this._setSpec));
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else if (this._setSpec.startsWith("com_")) {
            try {
                return new SolrFilterResult("item.communities:" + ClientUtils.escapeQueryChars((String)this._setSpec));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new SolrFilterResult();
    }
}

