/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.util;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xoai.exceptions.InvalidMetadataFieldException;

public class MetadataFieldManager {
    private static Logger log = LogManager.getLogger(MetadataFieldManager.class);
    private static MetadataFieldManager _manager = null;
    private Map<String, Integer> _map = new HashMap<String, Integer>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getFieldID(Context context, String field) throws InvalidMetadataFieldException, SQLException {
        TableRowIterator iterator;
        if (_manager == null) {
            _manager = new MetadataFieldManager();
        }
        if (_manager.hasField(field)) return _manager.getField(field);
        String[] pieces = field.split(Pattern.quote("."));
        if (pieces.length <= 1) throw new InvalidMetadataFieldException();
        String schema = pieces[0];
        String element = pieces[1];
        String qualifier = null;
        if (pieces.length > 2) {
            qualifier = pieces[2];
        }
        String query = "SELECT mfr.metadata_field_id as mid FROM metadatafieldregistry mfr, metadataschemaregistry msr WHERE mfr.metadata_schema_id=mfr.metadata_schema_id AND msr.short_id = ? AND mfr.element = ?";
        if (qualifier == null) {
            query = query + " AND mfr.qualifier is NULL";
            log.debug((Object)("Query: " + query));
            iterator = DatabaseManager.query((Context)context, (String)query, (Object[])new Object[]{schema, element});
        } else {
            log.debug((Object)("Qualifier: " + qualifier));
            query = query + " AND mfr.qualifier = ?";
            log.debug((Object)("Query: " + query));
            iterator = DatabaseManager.query((Context)context, (String)query, (Object[])new Object[]{schema, element, qualifier});
        }
        if (!iterator.hasNext()) throw new InvalidMetadataFieldException();
        _manager.add(field, iterator.next().getIntColumn("mid"));
        return _manager.getField(field);
    }

    private MetadataFieldManager() {
    }

    public boolean hasField(String field) {
        return this._map.containsKey(field);
    }

    public int getField(String field) {
        return this._map.get(field);
    }

    public void add(String field, int id) {
        this._map.put(field, new Integer(id));
    }
}

