/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.util;

import com.lyncode.xoai.dataprovider.OAIDataProvider;
import com.lyncode.xoai.dataprovider.OAIRequestParameters;
import com.lyncode.xoai.dataprovider.core.XOAIManager;
import com.lyncode.xoai.dataprovider.exceptions.MetadataBindException;
import com.lyncode.xoai.dataprovider.exceptions.OAIException;
import com.lyncode.xoai.dataprovider.util.Base64Utils;
import com.lyncode.xoai.dataprovider.util.MarshallingUtils;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Utils;
import org.dspace.xoai.data.DSpaceDatabaseItem;
import org.dspace.xoai.util.ItemUtils;

public class XOAICacheManager {
    private static Logger log = LogManager.getLogger(XOAICacheManager.class);
    private static final String ITEMDIR = File.separator + "items";
    private static final String REQUESTDIR = File.separator + "requests";
    private static final String DATEFILE = File.separator + "date.file";
    private static String baseDir = null;
    private static final SimpleDateFormat format = new SimpleDateFormat();

    private static String getBaseDir() {
        if (baseDir == null) {
            String dir;
            baseDir = dir = ConfigurationManager.getProperty((String)"oai", (String)"cache.dir");
        }
        return baseDir;
    }

    private static File getCachedResponseFile(String id) {
        File dir = new File(XOAICacheManager.getBaseDir() + REQUESTDIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String name = File.separator + Base64Utils.encode((String)id);
        return new File(XOAICacheManager.getBaseDir() + REQUESTDIR + name);
    }

    private static File getMetadataCache(Item item) {
        File dir = new File(XOAICacheManager.getBaseDir() + ITEMDIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String name = File.separator + item.getHandle().replace('/', '_');
        return new File(XOAICacheManager.getBaseDir() + ITEMDIR + name);
    }

    public static void compileItem(DSpaceDatabaseItem item) {
        File metadataCache = XOAICacheManager.getMetadataCache(item.getItem());
        if (metadataCache.exists()) {
            metadataCache.delete();
        }
        XOAICacheManager.getMetadata(item);
    }

    public static String getCompiledMetadata(DSpaceDatabaseItem item) throws MetadataBindException {
        String compiled;
        log.debug((Object)"Trying to find compiled item");
        File metadataCache = XOAICacheManager.getMetadataCache(item.getItem());
        if (!metadataCache.exists()) {
            log.debug((Object)"This is not a compiled item");
            Metadata metadata = ItemUtils.retrieveMetadata(item.getItem());
            try {
                FileOutputStream output = new FileOutputStream(metadataCache);
                MarshallingUtils.writeMetadata((OutputStream)output, (Metadata)metadata);
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("Could not open file for writing: " + metadataCache.getPath()), (Throwable)e);
            }
            catch (MetadataBindException e) {
                log.warn((Object)("Unable to export in-memory metadata into file: " + metadataCache.getPath()), (Throwable)e);
            }
        }
        log.debug((Object)"This is a compiled item!");
        try {
            FileInputStream input = new FileInputStream(metadataCache);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Utils.bufferedCopy((InputStream)input, (OutputStream)output);
            input.close();
            output.close();
            compiled = output.toString();
        }
        catch (Exception e) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            log.warn((Object)e.getMessage(), (Throwable)e);
            MarshallingUtils.writeMetadata((OutputStream)output, (Metadata)ItemUtils.retrieveMetadata(item.getItem()));
            compiled = output.toString();
        }
        return compiled;
    }

    public static Metadata getMetadata(DSpaceDatabaseItem item) {
        Metadata metadata;
        log.debug((Object)"Trying to find compiled item");
        File metadataCache = XOAICacheManager.getMetadataCache(item.getItem());
        if (!metadataCache.exists()) {
            log.debug((Object)"This is not a compiled item");
            metadata = ItemUtils.retrieveMetadata(item.getItem());
            try {
                FileOutputStream output = new FileOutputStream(metadataCache);
                MarshallingUtils.writeMetadata((OutputStream)output, (Metadata)metadata);
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("Could not open file for writing: " + metadataCache.getPath()), (Throwable)e);
            }
            catch (MetadataBindException e) {
                log.warn((Object)("Unable to export in-memory metadata into file: " + metadataCache.getPath()), (Throwable)e);
            }
        } else {
            log.debug((Object)"This is a compiled item!");
            try {
                FileInputStream input = new FileInputStream(metadataCache);
                metadata = MarshallingUtils.readMetadata((InputStream)input);
                input.close();
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                metadata = ItemUtils.retrieveMetadata(item.getItem());
            }
        }
        return metadata;
    }

    private static String getStaticHead() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + (XOAIManager.getManager().hasStyleSheet() ? "<?xml-stylesheet type=\"text/xsl\" href=\"" + XOAIManager.getManager().getStyleSheet() + "\"?>" : "") + "<OAI-PMH xmlns=\"http://www.openarchives.org/OAI/2.0/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + "xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/ http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd\">";
    }

    public static void handle(String identification, OAIDataProvider dataProvider, OAIRequestParameters parameters, OutputStream out) throws IOException {
        int len;
        boolean caching = ConfigurationManager.getBooleanProperty((String)"oai", (String)"cache.enabled", (boolean)true);
        File cachedResponse = XOAICacheManager.getCachedResponseFile(identification);
        if (!caching || !cachedResponse.exists()) {
            log.debug((Object)"[XOAI] Result not cached");
            try {
                ByteArrayOutputStream intermediate = new ByteArrayOutputStream();
                dataProvider.handle(parameters, (OutputStream)intermediate);
                String xoaiResponse = intermediate.toString();
                String end = "</responseDate>";
                int pos = xoaiResponse.indexOf(end);
                if (pos > 0) {
                    xoaiResponse = xoaiResponse.substring(pos + end.length());
                }
                FileOutputStream output = new FileOutputStream(cachedResponse);
                output.write(xoaiResponse.getBytes());
                output.flush();
                output.close();
            }
            catch (OAIException e) {
                if (cachedResponse.exists()) {
                    cachedResponse.delete();
                }
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            log.debug((Object)"[OAI 2.0] Cached Result");
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        out.write((XOAICacheManager.getStaticHead() + "<responseDate>" + format.format(new Date()) + "</responseDate>").getBytes());
        FileInputStream in = new FileInputStream(cachedResponse);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
    }

    public static Date getLastCompilationDate() {
        try {
            FileInputStream fstream = new FileInputStream(XOAICacheManager.getBaseDir() + DATEFILE);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            try {
                Date d = format.parse(br.readLine());
                return d;
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                try {
                    fstream.close();
                    return null;
                }
                catch (Exception e1) {
                    log.debug((Object)e1.getMessage(), (Throwable)e1);
                    return null;
                }
            }
        }
        catch (FileNotFoundException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void main(String ... args) {
        try {
            FileOutputStream fstream = new FileOutputStream("test");
            fstream.write(format.format(new Date()).getBytes());
            fstream.flush();
            fstream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(format.format(new Date()));
    }

    public static void setLastCompilationDate(Date date) {
        try {
            FileOutputStream fstream = new FileOutputStream(XOAICacheManager.getBaseDir() + DATEFILE);
            fstream.write(format.format(date).getBytes());
            fstream.flush();
            fstream.close();
        }
        catch (Exception e) {
            log.debug((Object)"Error writing the date");
        }
    }

    public static void deleteCachedResponses() {
        File directory = new File(XOAICacheManager.getBaseDir() + REQUESTDIR);
        if (directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                file.delete();
            }
        }
    }

    public static void deleteCompiledItems() {
        new File(XOAICacheManager.getBaseDir() + DATEFILE).delete();
        File directory = new File(XOAICacheManager.getBaseDir() + ITEMDIR);
        if (directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                file.delete();
            }
        }
    }
}

