/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.data;

import com.lyncode.xoai.dataprovider.core.ListItemIdentifiersResult;
import com.lyncode.xoai.dataprovider.core.ListItemsResults;
import com.lyncode.xoai.dataprovider.data.AbstractItem;
import com.lyncode.xoai.dataprovider.exceptions.IdDoesNotExistException;
import com.lyncode.xoai.dataprovider.filter.Filter;
import com.lyncode.xoai.dataprovider.filter.FilterScope;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xoai.data.DSpaceDatabaseItem;
import org.dspace.xoai.data.DSpaceItemRepository;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.DatabaseFilterResult;

public class DSpaceItemDatabaseRepository
extends DSpaceItemRepository {
    private static Logger log = LogManager.getLogger(DSpaceItemDatabaseRepository.class);
    private Context _context;

    public DSpaceItemDatabaseRepository(Context context) {
        this._context = context;
    }

    public AbstractItem getItem(String id) throws IdDoesNotExistException {
        try {
            String[] parts = id.split(Pattern.quote(":"));
            if (parts.length == 3) {
                DSpaceObject obj = HandleManager.resolveToObject((Context)this._context, (String)parts[2]);
                if (obj == null) {
                    throw new IdDoesNotExistException();
                }
                if (!(obj instanceof Item)) {
                    throw new IdDoesNotExistException();
                }
                return new DSpaceDatabaseItem((Item)obj);
            }
        }
        catch (NumberFormatException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new IdDoesNotExistException();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IdDoesNotExistException();
        }
        throw new IdDoesNotExistException();
    }

    private ListItemIdentifiersResult getIdentifierResult(String query, String countQuery, List<Object> countParameters, List<Object> parameters, int length) {
        boolean hasMore = false;
        ArrayList<DSpaceDatabaseItem> list = new ArrayList<DSpaceDatabaseItem>();
        int count = -1;
        try {
            count = DatabaseManager.querySingle((Context)this._context, (String)countQuery, (Object[])new Object[]{countParameters}).getIntColumn("count");
        }
        catch (SQLException e1) {
            log.error((Object)"Unable to retrieve number of items that match");
        }
        try {
            parameters.add(length + 1);
            TableRowIterator rows = DatabaseManager.queryTable((Context)this._context, (String)"item", (String)query, (Object[])parameters.toArray());
            ItemIterator iterator = new ItemIterator(this._context, rows);
            for (int i = 0; iterator.hasNext() && i < length; ++i) {
                list.add(new DSpaceDatabaseItem(iterator.next()));
            }
            hasMore = iterator.hasNext();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new ListItemIdentifiersResult(hasMore, list, count);
    }

    private ListItemsResults getResult(String query, String countQuery, List<Object> countParameters, List<Object> parameters, int length) {
        boolean hasMore = false;
        ArrayList<DSpaceDatabaseItem> list = new ArrayList<DSpaceDatabaseItem>();
        int count = -1;
        try {
            count = DatabaseManager.querySingle((Context)this._context, (String)countQuery, (Object[])new Object[]{countParameters}).getIntColumn("count");
        }
        catch (SQLException e1) {
            log.error((Object)"Unable to retrieve number of items that match");
        }
        try {
            parameters.add(length + 1);
            TableRowIterator rows = DatabaseManager.queryTable((Context)this._context, (String)"item", (String)query, (Object[])parameters.toArray());
            ItemIterator iterator = new ItemIterator(this._context, rows);
            for (int i = 0; iterator.hasNext() && i < length; ++i) {
                list.add(new DSpaceDatabaseItem(iterator.next()));
            }
            hasMore = iterator.hasNext();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new ListItemsResults(hasMore, list, count);
    }

    public ListItemsResults getItems(List<Filter> filters, int offset, int length) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<Object> countParameters = new ArrayList<Object>();
        String query = "SELECT i.* FROM item i ";
        String countQuery = "SELECT COUNT(*) as count FROM item i";
        ArrayList<String> whereCond = new ArrayList<String>();
        for (Filter filter : filters) {
            DSpaceFilter dspaceFilter;
            DatabaseFilterResult result;
            if (!(filter.getFilter() instanceof DSpaceFilter) || !(result = (dspaceFilter = (DSpaceFilter)filter.getFilter()).getWhere(this._context)).hasResult()) continue;
            if (filter.getScope() == FilterScope.MetadataFormat) {
                whereCond.add("(i.withdrawn=TRUE OR (" + result.getWhere() + "))");
            } else {
                whereCond.add("(" + result.getWhere() + ")");
            }
            parameters.addAll(result.getParameters());
            countParameters.addAll(result.getParameters());
        }
        String where = StringUtils.join(whereCond.iterator(), (String)" AND ");
        if (!where.equals("")) {
            query = query + " WHERE " + where;
            countQuery = countQuery + " WHERE " + where;
        }
        query = query + " ORDER BY i.item_id";
        String db = ConfigurationManager.getProperty((String)"db.name");
        boolean postgres = true;
        if ("oracle".equals(db)) {
            postgres = false;
        }
        if (postgres) {
            query = query + " OFFSET ? LIMIT ?";
        } else {
            query = "SELECT * FROM (" + query + ") WHERE ROWNUM BETWEEN ? AND ?";
            length += offset;
        }
        parameters.add(offset);
        return this.getResult(query, countQuery, countParameters, parameters, length);
    }

    public ListItemIdentifiersResult getItemIdentifiers(List<Filter> filters, int offset, int length) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<Object> countParameters = new ArrayList<Object>();
        String query = "SELECT i.* FROM item i ";
        String countQuery = "SELECT COUNT(*) as count FROM item i";
        ArrayList<String> whereCond = new ArrayList<String>();
        for (Filter filter : filters) {
            DSpaceFilter dspaceFilter;
            DatabaseFilterResult result;
            if (!(filter.getFilter() instanceof DSpaceFilter) || !(result = (dspaceFilter = (DSpaceFilter)filter.getFilter()).getWhere(this._context)).hasResult()) continue;
            if (filter.getScope() == FilterScope.MetadataFormat) {
                whereCond.add("(i.withdrawn=TRUE OR (" + result.getWhere() + "))");
            } else {
                whereCond.add("(" + result.getWhere() + ")");
            }
            parameters.addAll(result.getParameters());
            countParameters.addAll(result.getParameters());
        }
        String where = StringUtils.join(whereCond.iterator(), (String)" AND ");
        if (!where.equals("")) {
            query = query + " WHERE " + where;
            countQuery = countQuery + " WHERE " + where;
        }
        query = query + " ORDER BY i.item_id";
        String db = ConfigurationManager.getProperty((String)"db.name");
        boolean postgres = true;
        if ("oracle".equals(db)) {
            postgres = false;
        }
        if (postgres) {
            query = query + " OFFSET ? LIMIT ?";
        } else {
            query = "SELECT *, ROWNUM r FROM (" + query + ") WHERE r BETWEEN ? AND ?";
            length += offset;
        }
        parameters.add(offset);
        return this.getIdentifierResult(query, countQuery, countParameters, parameters, length);
    }
}

