/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.solr;

import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.dspace.xoai.solr.DSpaceSolrServer;
import org.dspace.xoai.solr.exceptions.DSpaceSolrException;
import org.dspace.xoai.solr.exceptions.SolrSearchEmptyException;

public class DSpaceSolrSearch {
    public static SolrDocumentList query(SolrQuery solrParams) throws DSpaceSolrException {
        try {
            SolrServer server = DSpaceSolrServer.getServer();
            solrParams.addSortField("item.id", SolrQuery.ORDER.asc);
            QueryResponse response = server.query((SolrParams)solrParams);
            return response.getResults();
        }
        catch (SolrServerException ex) {
            throw new DSpaceSolrException(ex.getMessage(), ex);
        }
    }

    public static SolrDocument querySingle(SolrQuery solrParams) throws SolrSearchEmptyException {
        try {
            SolrServer server = DSpaceSolrServer.getServer();
            solrParams.addSortField("item.id", SolrQuery.ORDER.asc);
            QueryResponse response = server.query((SolrParams)solrParams);
            if (response.getResults().getNumFound() > 0L) {
                return (SolrDocument)response.getResults().get(0);
            }
            throw new SolrSearchEmptyException();
        }
        catch (SolrServerException ex) {
            throw new SolrSearchEmptyException(ex.getMessage(), ex);
        }
    }
}

