/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DateUtils {
    private static Logger log = LogManager.getLogger(DateUtils.class);

    public static String formatToSolr(Date date) {
        return DateUtils.formatToSolr(date, true);
    }

    public static String formatToSolr(Date date, boolean init) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.'000Z'");
        if (!init) {
            sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.'999Z'");
        }
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String ret = sdf.format(date);
        return ret;
    }

    public static Date parseDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.getDefault());
        try {
            Date ret = format.parse(date);
            return ret;
        }
        catch (ParseException e) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            try {
                return format.parse(date);
            }
            catch (ParseException e1) {
                format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                try {
                    return format.parse(date);
                }
                catch (ParseException e2) {
                    format = new SimpleDateFormat("yyyy-MM", Locale.getDefault());
                    try {
                        return format.parse(date);
                    }
                    catch (ParseException e3) {
                        format = new SimpleDateFormat("yyyy", Locale.getDefault());
                        try {
                            return format.parse(date);
                        }
                        catch (ParseException e4) {
                            log.error((Object)e4.getMessage(), (Throwable)e);
                            return new Date();
                        }
                    }
                }
            }
        }
    }

    public static Date parseFromSolrDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.getDefault());
        try {
            Date ret = format.parse(date);
            return ret;
        }
        catch (ParseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new Date();
        }
    }

    public static Date toSolrDate(Date date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Date indexFormatExpiryDate = sdf.parse(sdf.format(date));
        return indexFormatExpiryDate;
    }
}

