/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.data;

import com.lyncode.xoai.dataprovider.core.ItemMetadata;
import com.lyncode.xoai.dataprovider.core.ReferenceSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.dspace.xoai.data.DSpaceItem;

public class DSpaceSolrItem
extends DSpaceItem {
    private static Logger log = LogManager.getLogger(DSpaceSolrItem.class);
    private String unparsedMD;
    private ItemMetadata metadata;
    private String handle;
    private Date lastMod;
    private List<ReferenceSet> sets;
    private boolean deleted;

    public DSpaceSolrItem(SolrDocument doc) {
        log.debug((Object)"Creating OAI Item from Solr source");
        this.unparsedMD = (String)doc.getFieldValue("item.compile");
        this.handle = (String)doc.getFieldValue("item.handle");
        this.lastMod = (Date)doc.getFieldValue("item.lastmodified");
        this.sets = new ArrayList<ReferenceSet>();
        for (Object obj : doc.getFieldValues("item.communities")) {
            this.sets.add(new ReferenceSet((String)obj));
        }
        for (Object obj : doc.getFieldValues("item.collections")) {
            this.sets.add(new ReferenceSet((String)obj));
        }
        this.deleted = (Boolean)doc.getFieldValue("item.deleted");
    }

    public ItemMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = new ItemMetadata(this.unparsedMD);
        }
        return this.metadata;
    }

    public Date getDatestamp() {
        return this.lastMod;
    }

    public List<ReferenceSet> getSets() {
        return this.sets;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    protected String getHandle() {
        return this.handle;
    }
}

