/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import java.util.ArrayList;
import org.dspace.core.Context;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.DatabaseFilterResult;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class AndFilter
extends DSpaceFilter {
    private DSpaceFilter left;
    private DSpaceFilter right;

    public AndFilter(DSpaceFilter left, DSpaceFilter right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public DatabaseFilterResult buildDatabaseQuery(Context context) {
        DatabaseFilterResult leftResult = this.left.buildDatabaseQuery(context);
        DatabaseFilterResult rightResult = this.right.buildDatabaseQuery(context);
        ArrayList<Object> param = new ArrayList<Object>();
        param.addAll(leftResult.getParameters());
        param.addAll(rightResult.getParameters());
        return new DatabaseFilterResult("(" + leftResult.getQuery() + ") AND (" + rightResult.getQuery() + ")", param);
    }

    @Override
    public SolrFilterResult buildSolrQuery() {
        return new SolrFilterResult("(" + this.left.buildSolrQuery().getQuery() + ") AND (" + this.right.buildSolrQuery().getQuery() + ")");
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        return this.left.isShown(item) && this.right.isShown(item);
    }
}

