/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import com.google.common.base.Function;
import com.lyncode.builder.ListBuilder;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.ParameterList;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.ParameterValue;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.SimpleType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.core.Context;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.exceptions.InvalidMetadataFieldException;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.data.DSpaceMetadataFilterOperator;
import org.dspace.xoai.filter.results.DatabaseFilterResult;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class DSpaceAtLeastOneMetadataFilter
extends DSpaceFilter {
    private static Logger log = LogManager.getLogger(DSpaceAtLeastOneMetadataFilter.class);
    private String field;
    private DSpaceMetadataFilterOperator operator = DSpaceMetadataFilterOperator.UNDEF;
    private List<String> values;

    private String getField() {
        if (this.field == null) {
            this.field = this.getConfiguration().get("field").asSimpleType().asString();
        }
        return this.field;
    }

    private List<String> getValues() {
        if (this.values == null) {
            ParameterValue parameterValue = this.getConfiguration().get("value");
            if (parameterValue == null) {
                parameterValue = this.getConfiguration().get("values");
            }
            if (parameterValue instanceof SimpleType) {
                this.values = new ArrayList<String>();
                this.values.add(((SimpleType)parameterValue).asString());
            } else {
                this.values = parameterValue instanceof ParameterList ? new ListBuilder().add((Collection)parameterValue.asParameterList().getValues()).build((Function)new Function<ParameterValue, String>(){

                    public String apply(ParameterValue elem) {
                        return elem.asSimpleType().asString();
                    }
                }) : new ArrayList<String>();
            }
        }
        return this.values;
    }

    private DSpaceMetadataFilterOperator getOperator() {
        if (this.operator == DSpaceMetadataFilterOperator.UNDEF) {
            this.operator = DSpaceMetadataFilterOperator.valueOf(this.getConfiguration().get("operator").asSimpleType().asString().toUpperCase());
        }
        return this.operator;
    }

    @Override
    public DatabaseFilterResult buildDatabaseQuery(Context context) {
        if (this.getField() != null) {
            try {
                int id = this.fieldResolver.getFieldID(context, this.getField());
                return this.getWhere(id, this.getValues());
            }
            catch (InvalidMetadataFieldException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (SQLException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return new DatabaseFilterResult();
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        if (this.getField() == null) {
            return true;
        }
        List<String> values = item.getMetadata(this.getField());
        for (String praticalValue : values) {
            block10: for (String theoreticValue : this.getValues()) {
                switch (this.getOperator()) {
                    case STARTS_WITH: {
                        if (!praticalValue.startsWith(theoreticValue)) continue block10;
                        return true;
                    }
                    case ENDS_WITH: {
                        if (!praticalValue.endsWith(theoreticValue)) continue block10;
                        return true;
                    }
                    case EQUAL: {
                        if (!praticalValue.equals(theoreticValue)) continue block10;
                        return true;
                    }
                    case GREATER: {
                        if (praticalValue.compareTo(theoreticValue) <= 0) continue block10;
                        return true;
                    }
                    case GREATER_OR_EQUAL: {
                        if (praticalValue.compareTo(theoreticValue) < 0) continue block10;
                        return true;
                    }
                    case LOWER: {
                        if (praticalValue.compareTo(theoreticValue) >= 0) continue block10;
                        return true;
                    }
                    case LOWER_OR_EQUAL: {
                        if (praticalValue.compareTo(theoreticValue) > 0) continue block10;
                        return true;
                    }
                }
                if (!praticalValue.contains(theoreticValue)) continue;
                return true;
            }
        }
        return false;
    }

    private DatabaseFilterResult getWhere(int mdid, List<String> values) {
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(mdid);
        for (String v : values) {
            this.buildWhere(v, parts, params);
        }
        if (parts.size() > 0) {
            String query = "EXISTS (SELECT tmp.* FROM metadatavalue tmp WHERE tmp.resource_id=i.item_id AND tmp.resource_type_id=2 AND tmp.metadata_field_id=? AND (" + StringUtils.join(parts.iterator(), (String)" OR ") + "))";
            return new DatabaseFilterResult(query, params);
        }
        return new DatabaseFilterResult();
    }

    private void buildWhere(String value, List<String> parts, List<Object> params) {
        switch (this.getOperator()) {
            case ENDS_WITH: {
                parts.add("(tmp.text_value LIKE ?)");
                params.add("%" + value);
                break;
            }
            case STARTS_WITH: {
                parts.add("(tmp.text_value LIKE ?)");
                params.add(value + "%");
                break;
            }
            case EQUAL: {
                parts.add("(tmp.text_value LIKE ?)");
                params.add(value);
                break;
            }
            case GREATER: {
                parts.add("(tmp.text_value > ?)");
                params.add(value);
                break;
            }
            case LOWER: {
                parts.add("(tmp.text_value < ?)");
                params.add(value);
                break;
            }
            case LOWER_OR_EQUAL: {
                parts.add("(tmp.text_value <= ?)");
                params.add(value);
                break;
            }
            case GREATER_OR_EQUAL: {
                parts.add("(tmp.text_value >= ?)");
                params.add(value);
                break;
            }
            default: {
                parts.add("(tmp.text_value LIKE ?)");
                params.add("%" + value + "%");
            }
        }
    }

    @Override
    public SolrFilterResult buildSolrQuery() {
        String field = this.getField();
        ArrayList<String> parts = new ArrayList<String>();
        if (this.getField() != null) {
            for (String v : this.getValues()) {
                this.buildQuery("metadata." + field, ClientUtils.escapeQueryChars((String)v), parts);
            }
            if (parts.size() > 0) {
                return new SolrFilterResult(StringUtils.join(parts.iterator(), (String)" OR "));
            }
        }
        return new SolrFilterResult();
    }

    private void buildQuery(String field, String value, List<String> parts) {
        switch (this.getOperator()) {
            case ENDS_WITH: {
                parts.add("(" + field + ":*" + value + ")");
                break;
            }
            case STARTS_WITH: {
                parts.add("(" + field + ":" + value + "*)");
                break;
            }
            case EQUAL: {
                parts.add("(" + field + ":" + value + ")");
                break;
            }
            case GREATER: {
                parts.add("(" + field + ":[" + value + " TO *])");
                break;
            }
            case LOWER: {
                parts.add("(" + field + ":[* TO " + value + "])");
                break;
            }
            case LOWER_OR_EQUAL: {
                parts.add("(-(" + field + ":[" + value + " TO *]))");
                break;
            }
            case GREATER_OR_EQUAL: {
                parts.add("(-(" + field + ":[* TO " + value + "]))");
                break;
            }
            default: {
                parts.add("(" + field + ":*" + value + "*)");
            }
        }
    }
}

