/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.DatabaseFilterResult;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class DSpaceAuthorizationFilter
extends DSpaceFilter {
    private static Logger log = LogManager.getLogger(DSpaceAuthorizationFilter.class);

    @Override
    public DatabaseFilterResult buildDatabaseQuery(Context context) {
        ArrayList<Object> params = new ArrayList<Object>();
        return new DatabaseFilterResult("EXISTS (SELECT p.action_id FROM resourcepolicy p, bundle2bitstream b, bundle bu, item2bundle ib WHERE p.resource_type_id=0 AND p.resource_id=b.bitstream_id AND p.epersongroup_id=0 AND b.bundle_id=ib.bundle_id AND bu.bundle_id=b.bundle_id AND bu.name='ORIGINAL' AND ib.item_id=i.item_id)", params);
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        boolean pub = false;
        try {
            String handle = DSpaceItem.parseHandle(item.getIdentifier());
            if (handle == null) {
                return false;
            }
            Item dspaceItem = (Item)HandleManager.resolveToObject((Context)this.context, (String)handle);
            if (dspaceItem == null) {
                return false;
            }
            pub = AuthorizeManager.authorizeActionBoolean((Context)this.context, (DSpaceObject)dspaceItem, (int)0);
        }
        catch (SQLException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return pub;
    }

    @Override
    public SolrFilterResult buildSolrQuery() {
        return new SolrFilterResult("item.public:true");
    }
}

