/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import com.lyncode.xoai.dataprovider.core.ReferenceSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.DatabaseFilterResult;
import org.dspace.xoai.filter.results.SolrFilterResult;
import org.dspace.xoai.services.api.database.CollectionsService;
import org.dspace.xoai.services.api.database.HandleResolver;

public class DSpaceSetSpecFilter
extends DSpaceFilter {
    private static Logger log = LogManager.getLogger(DSpaceSetSpecFilter.class);
    private String setSpec;
    private HandleResolver handleResolver;
    private CollectionsService collectionsService;

    public DSpaceSetSpecFilter(CollectionsService collectionsService, HandleResolver handleResolver, String spec) {
        this.collectionsService = collectionsService;
        this.handleResolver = handleResolver;
        this.setSpec = spec;
    }

    @Override
    public DatabaseFilterResult buildDatabaseQuery(Context context) {
        if (this.setSpec.startsWith("col_")) {
            try {
                DSpaceObject dso = this.handleResolver.resolve(this.setSpec.replace("col_", "").replace("_", "/"));
                if (dso != null) {
                    return new DatabaseFilterResult("EXISTS (SELECT tmp.* FROM collection2item tmp WHERE tmp.resource_id=i.item_id AND collection_id = ?)", dso.getID());
                }
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else if (this.setSpec.startsWith("com_")) {
            try {
                DSpaceObject dso = this.handleResolver.resolve(this.setSpec.replace("com_", "").replace("_", "/"));
                if (dso != null) {
                    List<Integer> list = this.collectionsService.getAllSubCollections(dso.getID());
                    String subCollections = StringUtils.join(list.iterator(), (String)",");
                    return new DatabaseFilterResult("EXISTS (SELECT tmp.* FROM collection2item tmp WHERE tmp.resource_id=i.item_id AND collection_id IN (" + subCollections + "))", new Object[0]);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new DatabaseFilterResult();
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        for (ReferenceSet s : item.getSets()) {
            if (!s.getSetSpec().equals(this.setSpec)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SolrFilterResult buildSolrQuery() {
        if (this.setSpec.startsWith("col_")) {
            try {
                return new SolrFilterResult("item.collections:" + ClientUtils.escapeQueryChars((String)this.setSpec));
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else if (this.setSpec.startsWith("com_")) {
            try {
                return new SolrFilterResult("item.communities:" + ClientUtils.escapeQueryChars((String)this.setSpec));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new SolrFilterResult();
    }
}

