/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import org.dspace.core.Context;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.DatabaseFilterResult;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class NotFilter
extends DSpaceFilter {
    private DSpaceFilter inFilter;

    public NotFilter(DSpaceFilter inFilter) {
        this.inFilter = inFilter;
    }

    @Override
    public DatabaseFilterResult buildDatabaseQuery(Context context) {
        DatabaseFilterResult result = this.inFilter.buildDatabaseQuery(context);
        return new DatabaseFilterResult("NOT (" + result.getQuery() + ")", result.getParameters());
    }

    @Override
    public SolrFilterResult buildSolrQuery() {
        return new SolrFilterResult("*:* AND NOT(" + this.inFilter.buildSolrQuery().getQuery() + ")");
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        return !this.inFilter.isShown(item);
    }
}

