/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.api.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;

public class DatabaseQuery {
    private static Logger log = Logger.getLogger(DatabaseQuery.class);
    private String query;
    private List<Object> parameters;
    private Context context;
    private Integer total;
    private String countQuery;
    private List<Object> countParameters;

    public DatabaseQuery(Context context) {
        this.context = context;
        this.parameters = new ArrayList<Object>();
    }

    public String getQuery() {
        return this.query;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public DatabaseQuery withQuery(String query) {
        this.query = query;
        return this;
    }

    public DatabaseQuery withParameters(List<Object> parameters) {
        this.parameters.addAll(parameters);
        return this;
    }

    public DatabaseQuery withCountQuery(String query, List<Object> parameters) {
        this.countQuery = query;
        this.countParameters = parameters;
        return this;
    }

    public int getTotal() {
        if (this.total == null) {
            try {
                this.total = DatabaseManager.querySingle((Context)this.context, (String)this.countQuery, (Object[])new Object[]{this.countParameters}).getIntColumn("count");
            }
            catch (SQLException e1) {
                log.error((Object)"Unable to retrieve number of items that match");
                this.total = -1;
            }
        }
        return this.total;
    }
}

