/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.database;

import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xoai.exceptions.InvalidMetadataFieldException;
import org.dspace.xoai.services.api.database.EarliestDateResolver;
import org.dspace.xoai.services.api.database.FieldResolver;
import org.dspace.xoai.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DSpaceEarliestDateResolver
implements EarliestDateResolver {
    private static final Logger log = LogManager.getLogger(DSpaceEarliestDateResolver.class);
    @Autowired
    private FieldResolver fieldResolver;

    @Override
    public Date getEarliestDate(Context context) throws InvalidMetadataFieldException, SQLException {
        TableRowIterator iterator;
        boolean postgres;
        String query = "SELECT MIN(text_value) as value FROM metadatavalue WHERE metadata_field_id = ?";
        boolean bl = postgres = !DatabaseManager.isOracle();
        if (!postgres) {
            query = "SELECT MIN(TO_CHAR(text_value)) as value FROM metadatavalue WHERE metadata_field_id = ?";
        }
        if ((iterator = DatabaseManager.query((Context)context, (String)query, (Object[])new Object[]{this.fieldResolver.getFieldID(context, "dc.date.available")})).hasNext()) {
            String str = iterator.next().getStringColumn("value");
            try {
                Date d = DateUtils.parse(str);
                if (d != null) {
                    return d;
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new Date();
    }
}

