/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.database;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xoai.exceptions.InvalidMetadataFieldException;
import org.dspace.xoai.services.api.database.FieldResolver;
import org.dspace.xoai.services.impl.database.MetadataFieldCache;

public class DSpaceFieldResolver
implements FieldResolver {
    private MetadataFieldCache metadataFieldCache = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getFieldID(Context context, String field) throws InvalidMetadataFieldException, SQLException {
        TableRowIterator iterator;
        if (this.metadataFieldCache == null) {
            this.metadataFieldCache = new MetadataFieldCache();
        }
        if (this.metadataFieldCache.hasField(field)) return this.metadataFieldCache.getField(field);
        String[] pieces = field.split(Pattern.quote("."));
        if (pieces.length <= 1) throw new InvalidMetadataFieldException();
        String schema = pieces[0];
        String element = pieces[1];
        String qualifier = null;
        if (pieces.length > 2) {
            qualifier = pieces[2];
        }
        String query = "SELECT mfr.metadata_field_id as mid FROM metadatafieldregistry mfr, metadataschemaregistry msr WHERE mfr.metadata_schema_id=mfr.metadata_schema_id AND msr.short_id = ? AND mfr.element = ?";
        if (qualifier == null) {
            query = query + " AND mfr.qualifier is NULL";
            iterator = DatabaseManager.query((Context)context, (String)query, (Object[])new Object[]{schema, element});
        } else {
            query = query + " AND mfr.qualifier = ?";
            iterator = DatabaseManager.query((Context)context, (String)query, (Object[])new Object[]{schema, element, qualifier});
        }
        if (!iterator.hasNext()) throw new InvalidMetadataFieldException();
        this.metadataFieldCache.add(field, iterator.next().getIntColumn("mid"));
        return this.metadataFieldCache.getField(field);
    }
}

