/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.xoai;

import com.lyncode.xoai.dataprovider.core.ListItemIdentifiersResult;
import com.lyncode.xoai.dataprovider.core.ListItemsResults;
import com.lyncode.xoai.dataprovider.core.ReferenceSet;
import com.lyncode.xoai.dataprovider.data.Item;
import com.lyncode.xoai.dataprovider.exceptions.IdDoesNotExistException;
import com.lyncode.xoai.dataprovider.exceptions.OAIException;
import com.lyncode.xoai.dataprovider.filter.ScopedFilter;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xoai.data.DSpaceDatabaseItem;
import org.dspace.xoai.data.DSpaceSet;
import org.dspace.xoai.services.api.cache.XOAIItemCacheService;
import org.dspace.xoai.services.api.config.ConfigurationService;
import org.dspace.xoai.services.api.context.ContextService;
import org.dspace.xoai.services.api.context.ContextServiceException;
import org.dspace.xoai.services.api.database.CollectionsService;
import org.dspace.xoai.services.api.database.DatabaseQuery;
import org.dspace.xoai.services.api.database.DatabaseQueryException;
import org.dspace.xoai.services.api.database.DatabaseQueryResolver;
import org.dspace.xoai.services.api.database.HandleResolver;
import org.dspace.xoai.services.impl.xoai.DSpaceItemRepository;
import org.dspace.xoai.util.ItemUtils;

public class DSpaceItemDatabaseRepository
extends DSpaceItemRepository {
    private static Logger log = LogManager.getLogger(DSpaceItemDatabaseRepository.class);
    private XOAIItemCacheService cacheService;
    private boolean useCache;
    private DatabaseQueryResolver queryResolver;
    private ContextService context;
    private CollectionsService collectionsService;
    private ConfigurationService configurationService;

    public DSpaceItemDatabaseRepository(ConfigurationService configurationService, CollectionsService collectionsService, HandleResolver handleResolver, XOAIItemCacheService cacheService, DatabaseQueryResolver queryResolver, ContextService context) {
        super(collectionsService, handleResolver);
        this.configurationService = configurationService;
        this.collectionsService = collectionsService;
        this.cacheService = cacheService;
        this.queryResolver = queryResolver;
        this.context = context;
        this.useCache = configurationService.getBooleanProperty("oai", "cache.enabled", true);
    }

    private Metadata getMetadata(org.dspace.content.Item item) throws IOException {
        if (this.useCache) {
            if (!this.cacheService.hasCache(item)) {
                this.cacheService.put(item, ItemUtils.retrieveMetadata(item));
            }
            return this.cacheService.get(item);
        }
        return ItemUtils.retrieveMetadata(item);
    }

    private List<ReferenceSet> getSets(org.dspace.content.Item item) {
        ArrayList<ReferenceSet> sets = new ArrayList<ReferenceSet>();
        ArrayList<Community> coms = new ArrayList<Community>();
        try {
            Collection[] itemCollections;
            for (Collection col : itemCollections = item.getCollections()) {
                DSpaceSet s = new DSpaceSet(col);
                sets.add((ReferenceSet)s);
                for (Community com : this.collectionsService.flatParentCommunities(col)) {
                    if (coms.contains(com)) continue;
                    coms.add(com);
                }
            }
            for (Community com : coms) {
                DSpaceSet s = new DSpaceSet(com);
                sets.add((ReferenceSet)s);
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return sets;
    }

    public Item getItem(String id) throws IdDoesNotExistException, OAIException {
        try {
            String[] parts = id.split(Pattern.quote(":"));
            if (parts.length == 3) {
                DSpaceObject obj = HandleManager.resolveToObject((Context)this.context.getContext(), (String)parts[2]);
                if (obj == null) {
                    throw new IdDoesNotExistException();
                }
                if (!(obj instanceof Item)) {
                    throw new IdDoesNotExistException();
                }
                org.dspace.content.Item item = (org.dspace.content.Item)obj;
                return new DSpaceDatabaseItem(item, this.getMetadata(item), this.getSets(item));
            }
        }
        catch (NumberFormatException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new IdDoesNotExistException();
        }
        catch (SQLException e) {
            throw new OAIException((Exception)e);
        }
        catch (IOException e) {
            throw new OAIException((Exception)e);
        }
        catch (ContextServiceException e) {
            throw new OAIException((Exception)e);
        }
        throw new IdDoesNotExistException();
    }

    public ListItemsResults getItems(List<ScopedFilter> filters, int offset, int length) throws OAIException {
        ArrayList<DSpaceDatabaseItem> list = new ArrayList<DSpaceDatabaseItem>();
        try {
            DatabaseQuery databaseQuery = this.queryResolver.buildQuery(filters, offset, length);
            TableRowIterator rowIterator = DatabaseManager.queryTable((Context)this.context.getContext(), (String)"item", (String)databaseQuery.getQuery(), (Object[])databaseQuery.getParameters().toArray());
            ItemIterator iterator = new ItemIterator(this.context.getContext(), rowIterator);
            for (int i = 0; iterator.hasNext() && i < length; ++i) {
                org.dspace.content.Item it = iterator.next();
                list.add(new DSpaceDatabaseItem(it, this.getMetadata(it), this.getSets(it)));
            }
            return new ListItemsResults(databaseQuery.getTotal() > offset + length, list, databaseQuery.getTotal());
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (DatabaseQueryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ContextServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new ListItemsResults(false, list, 0);
    }

    public ListItemIdentifiersResult getItemIdentifiers(List<ScopedFilter> filters, int offset, int length) throws OAIException {
        ArrayList<DSpaceDatabaseItem> list = new ArrayList<DSpaceDatabaseItem>();
        try {
            DatabaseQuery databaseQuery = this.queryResolver.buildQuery(filters, offset, length);
            TableRowIterator rowIterator = DatabaseManager.queryTable((Context)this.context.getContext(), (String)"item", (String)databaseQuery.getQuery(), (Object[])databaseQuery.getParameters().toArray());
            ItemIterator iterator = new ItemIterator(this.context.getContext(), rowIterator);
            for (int i = 0; iterator.hasNext() && i < length; ++i) {
                org.dspace.content.Item it = iterator.next();
                list.add(new DSpaceDatabaseItem(it, this.getMetadata(it), this.getSets(it)));
            }
            return new ListItemIdentifiersResult(databaseQuery.getTotal() > offset + length, list, databaseQuery.getTotal());
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (DatabaseQueryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ContextServiceException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new ListItemIdentifiersResult(false, list, 0);
    }
}

