/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.xoai;

import com.lyncode.xoai.dataprovider.services.api.ItemRepository;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.xoai.services.api.cache.XOAIItemCacheService;
import org.dspace.xoai.services.api.config.ConfigurationService;
import org.dspace.xoai.services.api.context.ContextService;
import org.dspace.xoai.services.api.context.ContextServiceException;
import org.dspace.xoai.services.api.database.CollectionsService;
import org.dspace.xoai.services.api.database.DatabaseQueryResolver;
import org.dspace.xoai.services.api.database.HandleResolver;
import org.dspace.xoai.services.api.solr.SolrQueryResolver;
import org.dspace.xoai.services.api.solr.SolrServerResolver;
import org.dspace.xoai.services.api.xoai.ItemRepositoryResolver;
import org.dspace.xoai.services.impl.xoai.DSpaceItemDatabaseRepository;
import org.dspace.xoai.services.impl.xoai.DSpaceItemSolrRepository;
import org.springframework.beans.factory.annotation.Autowired;

public class DSpaceItemRepositoryResolver
implements ItemRepositoryResolver {
    @Autowired
    ContextService contextService;
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    SolrServerResolver solrServerResolver;
    @Autowired
    SolrQueryResolver solrQueryResolver;
    @Autowired
    DatabaseQueryResolver databaseQueryResolver;
    @Autowired
    CollectionsService collectionsService;
    @Autowired
    private HandleResolver handleResolver;
    @Autowired
    private XOAIItemCacheService cacheService;
    private ItemRepository itemRepository;

    @Override
    public ItemRepository getItemRepository() throws ContextServiceException {
        if (this.itemRepository == null) {
            String storage = this.configurationService.getProperty("oai", "storage");
            if (storage == null || !storage.trim().toLowerCase().equals("database")) {
                try {
                    this.itemRepository = new DSpaceItemSolrRepository(this.solrServerResolver.getServer(), this.collectionsService, this.handleResolver, this.solrQueryResolver);
                }
                catch (SolrServerException e) {
                    throw new ContextServiceException(e.getMessage(), e);
                }
            } else {
                this.itemRepository = new DSpaceItemDatabaseRepository(this.configurationService, this.collectionsService, this.handleResolver, this.cacheService, this.databaseQueryResolver, this.contextService);
            }
        }
        return this.itemRepository;
    }
}

