/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.xoai;

import com.lyncode.xoai.dataprovider.core.ResumptionToken;
import com.lyncode.xoai.dataprovider.exceptions.BadResumptionToken;
import com.lyncode.xoai.dataprovider.services.api.ResumptionTokenFormatter;
import java.util.Date;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.xoai.util.DateUtils;

public class DSpaceResumptionTokenFormatter
implements ResumptionTokenFormatter {
    private static Logger log = LogManager.getLogger(DSpaceResumptionTokenFormatter.class);

    public ResumptionToken parse(String resumptionToken) throws BadResumptionToken {
        if (resumptionToken == null) {
            return new ResumptionToken();
        }
        String[] res = resumptionToken.split("/", -1);
        if (res.length != 5) {
            throw new BadResumptionToken();
        }
        try {
            int offset = Integer.parseInt(res[4]);
            String prefix = res[0].equals("") ? null : res[0];
            String set = res[3].equals("") ? null : res[3];
            Date from = res[1].equals("") ? null : DateUtils.parse(res[1]);
            Date until = res[2].equals("") ? null : DateUtils.parse(res[2]);
            return new ResumptionToken(offset, prefix, set, from, until);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BadResumptionToken();
        }
    }

    public String format(ResumptionToken resumptionToken) {
        String result = "";
        if (resumptionToken.hasMetadataPrefix()) {
            result = result + resumptionToken.getMetadataPrefix();
        }
        result = result + "/";
        if (resumptionToken.hasFrom()) {
            result = result + DateUtils.format(resumptionToken.getFrom());
        }
        result = result + "/";
        if (resumptionToken.hasUntil()) {
            result = result + DateUtils.format(resumptionToken.getUntil());
        }
        result = result + "/";
        if (resumptionToken.hasSet()) {
            result = result + resumptionToken.getSet();
        }
        result = result + "/";
        result = result + resumptionToken.getOffset();
        return result;
    }
}

