/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DateUtils {
    private static Logger log = LogManager.getLogger(DateUtils.class);

    public static String format(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("ZULU"));
        String ret = sdf.format(date);
        return ret;
    }

    public static Date parse(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("ZULU"));
        try {
            Date ret = format.parse(date);
            return ret;
        }
        catch (ParseException ex) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            try {
                return format.parse(date);
            }
            catch (ParseException e1) {
                format = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                try {
                    return format.parse(date);
                }
                catch (ParseException e2) {
                    format = new SimpleDateFormat("yyyy-MM", Locale.getDefault());
                    try {
                        return format.parse(date);
                    }
                    catch (ParseException e3) {
                        format = new SimpleDateFormat("yyyy", Locale.getDefault());
                        try {
                            return format.parse(date);
                        }
                        catch (ParseException e4) {
                            log.error((Object)e4.getMessage(), (Throwable)e4);
                            return new Date();
                        }
                    }
                }
            }
        }
    }

    public static Date parseFromSolrDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("ZULU"));
        try {
            Date ret = format.parse(date);
            return ret;
        }
        catch (ParseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new Date();
        }
    }
}

