/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.util;

import com.lyncode.xoai.dataprovider.xml.xoai.Element;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import com.lyncode.xoai.util.Base64Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Utils;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.util.URLUtils;

public class ItemUtils {
    private static Logger log = LogManager.getLogger(ItemUtils.class);

    private static Element getElement(List<Element> list, String name) {
        for (Element e : list) {
            if (!name.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    private static Element create(String name) {
        Element e = new Element();
        e.setName(name);
        return e;
    }

    private static Element.Field createValue(String name, String value) {
        Element.Field e = new Element.Field();
        e.setValue(value);
        e.setName(name);
        return e;
    }

    public static Metadata retrieveMetadata(Item item) {
        Metadatum[] vals;
        Metadata metadata = new Metadata();
        for (Metadatum val : vals = item.getMetadata("*", "*", "*", "*")) {
            Element language;
            Element valueElem = null;
            Element schema = ItemUtils.getElement(metadata.getElement(), val.schema);
            if (schema == null) {
                schema = ItemUtils.create(val.schema);
                metadata.getElement().add(schema);
            }
            valueElem = schema;
            if (val.element != null && !val.element.equals("")) {
                Element element = ItemUtils.getElement(schema.getElement(), val.element);
                if (element == null) {
                    element = ItemUtils.create(val.element);
                    schema.getElement().add(element);
                }
                valueElem = element;
                if (val.qualifier != null && !val.qualifier.equals("")) {
                    Element qualifier = ItemUtils.getElement(element.getElement(), val.qualifier);
                    if (qualifier == null) {
                        qualifier = ItemUtils.create(val.qualifier);
                        element.getElement().add(qualifier);
                    }
                    valueElem = qualifier;
                }
            }
            if (val.language != null && !val.language.equals("")) {
                language = ItemUtils.getElement(valueElem.getElement(), val.language);
                if (language == null) {
                    language = ItemUtils.create(val.language);
                    valueElem.getElement().add(language);
                }
                valueElem = language;
            } else {
                language = ItemUtils.getElement(valueElem.getElement(), "none");
                if (language == null) {
                    language = ItemUtils.create("none");
                    valueElem.getElement().add(language);
                }
                valueElem = language;
            }
            valueElem.getField().add(ItemUtils.createValue("value", val.value));
            if (val.authority == null) continue;
            valueElem.getField().add(ItemUtils.createValue("authority", val.authority));
            if (val.confidence == 0) continue;
            valueElem.getField().add(ItemUtils.createValue("confidence", val.confidence + ""));
        }
        Element bundles = ItemUtils.create("bundles");
        metadata.getElement().add(bundles);
        try {
            Bundle[] bs;
            for (Bundle b : bs = item.getBundles()) {
                Bitstream[] bits;
                Element bundle = ItemUtils.create("bundle");
                bundles.getElement().add(bundle);
                bundle.getField().add(ItemUtils.createValue("name", b.getName()));
                Element bitstreams = ItemUtils.create("bitstreams");
                bundle.getElement().add(bitstreams);
                for (Bitstream bit : bits = b.getBitstreams()) {
                    Item[] bi;
                    Element bitstream = ItemUtils.create("bitstream");
                    bitstreams.getElement().add(bitstream);
                    String url = "";
                    String bsName = bit.getName();
                    String sid = String.valueOf(bit.getSequenceID());
                    String baseUrl = ConfigurationManager.getProperty((String)"oai", (String)"bitstream.baseUrl");
                    String handle = null;
                    Bundle[] bn = bit.getBundles();
                    if (bn.length > 0 && (bi = bn[0].getItems()).length > 0) {
                        handle = bi[0].getHandle();
                    }
                    if (bsName == null) {
                        String[] ext = bit.getFormat().getExtensions();
                        bsName = "bitstream_" + sid + (ext.length > 0 ? ext[0] : "");
                    }
                    url = handle != null && baseUrl != null ? baseUrl + "/bitstream/" + handle + "/" + sid + "/" + URLUtils.encode(bsName) : URLUtils.encode(bsName);
                    String cks = bit.getChecksum();
                    String cka = bit.getChecksumAlgorithm();
                    String oname = bit.getSource();
                    String name = bit.getName();
                    String description = bit.getDescription();
                    if (name != null) {
                        bitstream.getField().add(ItemUtils.createValue("name", name));
                    }
                    if (oname != null) {
                        bitstream.getField().add(ItemUtils.createValue("originalName", name));
                    }
                    if (description != null) {
                        bitstream.getField().add(ItemUtils.createValue("description", description));
                    }
                    bitstream.getField().add(ItemUtils.createValue("format", bit.getFormat().getMIMEType()));
                    bitstream.getField().add(ItemUtils.createValue("size", "" + bit.getSize()));
                    bitstream.getField().add(ItemUtils.createValue("url", url));
                    bitstream.getField().add(ItemUtils.createValue("checksum", cks));
                    bitstream.getField().add(ItemUtils.createValue("checksumAlgorithm", cka));
                    bitstream.getField().add(ItemUtils.createValue("sid", bit.getSequenceID() + ""));
                }
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        Element other = ItemUtils.create("others");
        other.getField().add(ItemUtils.createValue("handle", item.getHandle()));
        other.getField().add(ItemUtils.createValue("identifier", DSpaceItem.buildIdentifier(item.getHandle())));
        other.getField().add(ItemUtils.createValue("lastModifyDate", item.getLastModified().toString()));
        metadata.getElement().add(other);
        Element repository = ItemUtils.create("repository");
        repository.getField().add(ItemUtils.createValue("name", ConfigurationManager.getProperty((String)"dspace.name")));
        repository.getField().add(ItemUtils.createValue("mail", ConfigurationManager.getProperty((String)"mail.admin")));
        metadata.getElement().add(repository);
        Element license = ItemUtils.create("license");
        try {
            Bundle licBundle;
            Bitstream[] licBits;
            Bundle[] licBundles = item.getBundles("LICENSE");
            if (licBundles.length > 0 && (licBits = (licBundle = licBundles[0]).getBitstreams()).length > 0) {
                Bitstream licBit = licBits[0];
                try {
                    InputStream in = licBit.retrieve();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Utils.bufferedCopy((InputStream)in, (OutputStream)out);
                    license.getField().add(ItemUtils.createValue("bin", Base64Utils.encode((String)out.toString())));
                    metadata.getElement().add(license);
                }
                catch (AuthorizeException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                catch (SQLException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (SQLException e1) {
            log.warn((Object)e1.getMessage(), (Throwable)e1);
        }
        return metadata;
    }
}

