/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.app;

import com.lyncode.xoai.dataprovider.core.Granularity;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.exceptions.MetadataBindException;
import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.xoai.app.BasicConfiguration;
import org.dspace.xoai.exceptions.CompilingException;
import org.dspace.xoai.services.api.CollectionsService;
import org.dspace.xoai.services.api.cache.XOAICacheService;
import org.dspace.xoai.services.api.cache.XOAIItemCacheService;
import org.dspace.xoai.services.api.cache.XOAILastCompilationCacheService;
import org.dspace.xoai.services.api.config.ConfigurationService;
import org.dspace.xoai.services.api.solr.SolrServerResolver;
import org.dspace.xoai.solr.DSpaceSolrSearch;
import org.dspace.xoai.solr.exceptions.DSpaceSolrException;
import org.dspace.xoai.solr.exceptions.DSpaceSolrIndexerException;
import org.dspace.xoai.util.ItemUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class XOAI {
    private static Logger log = LogManager.getLogger(XOAI.class);
    private final Context context;
    private boolean optimize;
    private final boolean verbose;
    private boolean clean;
    @Autowired
    private SolrServerResolver solrServerResolver;
    @Autowired
    private XOAILastCompilationCacheService xoaiLastCompilationCacheService;
    @Autowired
    private XOAIItemCacheService xoaiItemCacheService;
    @Autowired
    private CollectionsService collectionsService;
    private final AuthorizeService authorizeService;
    private final ItemService itemService;
    private static final String COMMAND_IMPORT = "import";
    private static final String COMMAND_CLEAN_CACHE = "clean-cache";
    private static final String COMMAND_COMPILE_ITEMS = "compile-items";
    private static final String COMMAND_ERASE_COMPILED_ITEMS = "erase-compiled-items";

    private List<String> getFileFormats(Item item) {
        ArrayList<String> formats = new ArrayList<String>();
        try {
            for (Bundle b : this.itemService.getBundles(item, "ORIGINAL")) {
                for (Bitstream bs : b.getBitstreams()) {
                    if (formats.contains(bs.getFormat(this.context).getMIMEType())) continue;
                    formats.add(bs.getFormat(this.context).getMIMEType());
                }
            }
        }
        catch (SQLException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return formats;
    }

    public XOAI(Context context, boolean optimize, boolean clean, boolean verbose) {
        this.context = context;
        this.optimize = optimize;
        this.clean = clean;
        this.verbose = verbose;
        this.authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
    }

    public XOAI(Context ctx, boolean hasOption) {
        this.context = ctx;
        this.verbose = hasOption;
        this.authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
    }

    private void println(String line) {
        System.out.println(line);
    }

    public int index() throws DSpaceSolrIndexerException {
        int result = 0;
        try {
            if (this.clean) {
                this.clearIndex();
                System.out.println("Using full import.");
                result = this.indexAll();
            } else {
                SolrQuery solrParams = new SolrQuery("*:*").addField("item.lastmodified").addSortField("item.lastmodified", SolrQuery.ORDER.desc).setRows(Integer.valueOf(1));
                SolrDocumentList results = DSpaceSolrSearch.query(this.solrServerResolver.getServer(), solrParams);
                if (results.getNumFound() == 0L) {
                    System.out.println("There are no indexed documents, using full import.");
                    result = this.indexAll();
                } else {
                    result = this.index((Date)((SolrDocument)results.get(0)).getFieldValue("item.lastmodified"));
                }
            }
            this.solrServerResolver.getServer().commit();
            if (this.optimize) {
                this.println("Optimizing Index");
                this.solrServerResolver.getServer().optimize();
                this.println("Index optimized");
            }
            this.xoaiLastCompilationCacheService.put(new Date());
            return result;
        }
        catch (IOException | SolrServerException | DSpaceSolrException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private int index(Date last) throws DSpaceSolrIndexerException {
        System.out.println("Incremental import. Searching for documents modified after: " + last.toString());
        try {
            Iterator iterator = this.itemService.findInArchiveOrWithdrawnDiscoverableModifiedSince(this.context, last);
            return this.index(iterator);
        }
        catch (SQLException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private int indexAll() throws DSpaceSolrIndexerException {
        System.out.println("Full import");
        try {
            Iterator iterator = this.itemService.findInArchiveOrWithdrawnDiscoverableModifiedSince(this.context, null);
            return this.index(iterator);
        }
        catch (SQLException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private int index(Iterator<Item> iterator) throws DSpaceSolrIndexerException {
        try {
            int i = 0;
            SolrServer server = this.solrServerResolver.getServer();
            while (iterator.hasNext()) {
                try {
                    Item item = iterator.next();
                    server.add(this.index(item));
                    this.context.uncacheEntity((ReloadableEntity)item);
                }
                catch (MetadataBindException | WritingXmlException | SQLException | ParseException | XMLStreamException ex) {
                    log.error((Object)ex.getMessage(), ex);
                }
                if (++i % 100 != 0) continue;
                System.out.println(i + " items imported so far...");
            }
            System.out.println("Total: " + i + " items");
            server.commit();
            return i;
        }
        catch (IOException | SolrServerException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private SolrInputDocument index(Item item) throws SQLException, MetadataBindException, ParseException, XMLStreamException, WritingXmlException {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("item.id", (Object)item.getID());
        boolean pub = this.isPublic(item);
        doc.addField("item.public", (Object)pub);
        String handle = item.getHandle();
        doc.addField("item.handle", (Object)handle);
        doc.addField("item.lastmodified", (Object)item.getLastModified());
        if (item.getSubmitter() != null) {
            doc.addField("item.submitter", (Object)item.getSubmitter().getEmail());
        }
        doc.addField("item.deleted", (Object)(item.isWithdrawn() ? "true" : "false"));
        for (Collection collection : item.getCollections()) {
            doc.addField("item.collections", (Object)("col_" + collection.getHandle().replace("/", "_")));
        }
        for (Community community : this.collectionsService.flatParentCommunities(this.context, item)) {
            doc.addField("item.communities", (Object)("com_" + community.getHandle().replace("/", "_")));
        }
        List allData = this.itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*");
        for (MetadataValue dc : allData) {
            MetadataField field = dc.getMetadataField();
            String key = "metadata." + field.getMetadataSchema().getName() + "." + field.getElement();
            if (field.getQualifier() != null) {
                key = key + "." + field.getQualifier();
            }
            doc.addField(key, (Object)dc.getValue());
            if (dc.getAuthority() == null) continue;
            doc.addField(key + ".authority", (Object)dc.getAuthority());
            doc.addField(key + ".confidence", (Object)(dc.getConfidence() + ""));
        }
        for (String f : this.getFileFormats(item)) {
            doc.addField("metadata.dc.format.mimetype", (Object)f);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlOutputContext xmlContext = XmlOutputContext.emptyContext((OutputStream)byteArrayOutputStream, (Granularity)Granularity.Second);
        ItemUtils.retrieveMetadata(this.context, item).write(xmlContext);
        xmlContext.getWriter().flush();
        xmlContext.getWriter().close();
        doc.addField("item.compile", (Object)byteArrayOutputStream.toString());
        if (this.verbose) {
            this.println("Item with handle " + handle + " indexed");
        }
        return doc;
    }

    private boolean isPublic(Item item) {
        boolean pub = false;
        try {
            pub = this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)item, 0);
        }
        catch (SQLException ex) {
            log.error((Object)ex.getMessage());
        }
        return pub;
    }

    private static boolean getKnownExplanation(Throwable t) {
        if (t instanceof ConnectException) {
            System.err.println("Solr server (" + ConfigurationManager.getProperty((String)"oai", (String)"solr.url") + ") is down, turn it on.");
            return true;
        }
        return false;
    }

    private static boolean searchForReason(Throwable t) {
        if (XOAI.getKnownExplanation(t)) {
            return true;
        }
        if (t.getCause() != null) {
            return XOAI.searchForReason(t.getCause());
        }
        return false;
    }

    private void clearIndex() throws DSpaceSolrIndexerException {
        try {
            System.out.println("Clearing index");
            this.solrServerResolver.getServer().deleteByQuery("*:*");
            this.solrServerResolver.getServer().commit();
            System.out.println("Index cleared");
        }
        catch (IOException | SolrServerException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private static void cleanCache(XOAIItemCacheService xoaiItemCacheService, XOAICacheService xoaiCacheService) throws IOException {
        System.out.println("Purging cached OAI responses.");
        xoaiItemCacheService.deleteAll();
        xoaiCacheService.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws IOException, ConfigurationException {
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext(new Class[]{BasicConfiguration.class});
        ConfigurationService configurationService = (ConfigurationService)applicationContext.getBean(ConfigurationService.class);
        XOAICacheService cacheService = (XOAICacheService)applicationContext.getBean(XOAICacheService.class);
        XOAIItemCacheService itemCacheService = (XOAIItemCacheService)applicationContext.getBean(XOAIItemCacheService.class);
        Context ctx = null;
        try {
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("c", "clear", false, "Clear index before indexing");
            options.addOption("o", "optimize", false, "Optimize index at the end");
            options.addOption("v", "verbose", false, "Verbose output");
            options.addOption("h", "help", false, "Shows some help");
            options.addOption("n", "number", true, "FOR DEVELOPMENT MUST DELETE");
            CommandLine line = parser.parse(options, argv);
            String[] validSolrCommands = new String[]{COMMAND_IMPORT, COMMAND_CLEAN_CACHE};
            String[] validDatabaseCommands = new String[]{COMMAND_CLEAN_CACHE, COMMAND_COMPILE_ITEMS, COMMAND_ERASE_COMPILED_ITEMS};
            boolean solr = true;
            solr = !"database".equals(configurationService.getProperty("oai", "storage"));
            boolean run = false;
            if (line.getArgs().length > 0) {
                if (solr) {
                    if (Arrays.asList(validSolrCommands).contains(line.getArgs()[0])) {
                        run = true;
                    }
                } else if (Arrays.asList(validDatabaseCommands).contains(line.getArgs()[0])) {
                    run = true;
                }
            }
            if (!line.hasOption('h') && run) {
                System.out.println("OAI 2.0 manager action started");
                long start = System.currentTimeMillis();
                String command = line.getArgs()[0];
                if (COMMAND_IMPORT.equals(command)) {
                    ctx = new Context(Context.Mode.READ_ONLY);
                    XOAI indexer = new XOAI(ctx, line.hasOption('o'), line.hasOption('c'), line.hasOption('v'));
                    applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)indexer);
                    int imported = indexer.index();
                    if (imported > 0) {
                        XOAI.cleanCache(itemCacheService, cacheService);
                    }
                } else if (COMMAND_CLEAN_CACHE.equals(command)) {
                    XOAI.cleanCache(itemCacheService, cacheService);
                } else if (COMMAND_COMPILE_ITEMS.equals(command)) {
                    ctx = new Context();
                    XOAI indexer = new XOAI(ctx, line.hasOption('v'));
                    applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)indexer);
                    indexer.compile();
                    XOAI.cleanCache(itemCacheService, cacheService);
                } else if (COMMAND_ERASE_COMPILED_ITEMS.equals(command)) {
                    XOAI.cleanCompiledItems(itemCacheService);
                    XOAI.cleanCache(itemCacheService, cacheService);
                }
                System.out.println("OAI 2.0 manager action ended. It took " + (System.currentTimeMillis() - start) / 1000L + " seconds.");
            } else {
                XOAI.usage();
            }
        }
        catch (Throwable ex) {
            if (!XOAI.searchForReason(ex)) {
                ex.printStackTrace();
            }
            log.error((Object)ex.getMessage(), ex);
        }
        finally {
            if (ctx != null && ctx.isValid()) {
                ctx.abort();
            }
        }
    }

    private static void cleanCompiledItems(XOAIItemCacheService itemCacheService) throws IOException {
        System.out.println("Purging compiled items");
        itemCacheService.deleteAll();
    }

    private void compile() throws CompilingException {
        try {
            Iterator iterator;
            Date last = this.xoaiLastCompilationCacheService.get();
            if (last == null) {
                System.out.println("Retrieving all items to be compiled");
                iterator = this.itemService.findAll(this.context);
            } else {
                System.out.println("Retrieving items modified after " + last + " to be compiled");
                iterator = this.itemService.findByLastModifiedSince(this.context, last);
            }
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                if (this.verbose) {
                    System.out.println("Compiling item with handle: " + item.getHandle());
                }
                this.xoaiItemCacheService.put(item, ItemUtils.retrieveMetadata(this.context, item));
            }
            this.xoaiLastCompilationCacheService.put(new Date());
        }
        catch (IOException | SQLException e) {
            throw new CompilingException(e);
        }
        System.out.println("Items compiled");
    }

    private static void usage() {
        boolean solr = true;
        boolean bl = solr = !"database".equals(ConfigurationManager.getProperty((String)"oai", (String)"storage"));
        if (solr) {
            System.out.println("OAI Manager Script");
            System.out.println("Syntax: oai <action> [parameters]");
            System.out.println("> Possible actions:");
            System.out.println("     import - To import DSpace items into OAI index and cache system");
            System.out.println("     clean-cache - Cleans the OAI cached responses");
            System.out.println("> Parameters:");
            System.out.println("     -o Optimize index after indexing (import only)");
            System.out.println("     -c Clear index (import only)");
            System.out.println("     -v Verbose output");
            System.out.println("     -h Shows this text");
        } else {
            System.out.println("OAI Manager Script");
            System.out.println("Syntax: oai <action> [parameters]");
            System.out.println("> Possible actions:");
            System.out.println("     clean-cache - Cleans the OAI cached responses");
            System.out.println("     compile-items - Compiles all DSpace items");
            System.out.println("     erase-compiled-items - Erase the OAI compiled items");
            System.out.println("> Parameters:");
            System.out.println("     -v Verbose output");
            System.out.println("     -h Shows this text");
        }
    }
}

