/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import com.lyncode.builder.DateBuilder;
import com.lyncode.xoai.dataprovider.services.api.DateProvider;
import com.lyncode.xoai.dataprovider.services.impl.BaseDateProvider;
import java.util.Date;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class DateUntilFilter
extends DSpaceFilter {
    private static final DateProvider dateProvider = new BaseDateProvider();
    private final Date date;

    public DateUntilFilter(Date date) {
        this.date = new DateBuilder(date).setMaxMilliseconds().build();
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        return item.getDatestamp().compareTo(this.date) <= 0;
    }

    @Override
    public SolrFilterResult buildSolrQuery() {
        String format = dateProvider.format(this.date).replace("Z", ".999Z");
        if (format.substring(11, 19).equals("00:00:00")) {
            format = format.substring(0, 11) + "23:59:59" + format.substring(19);
        }
        return new SolrFilterResult("item.lastmodified:[* TO " + ClientUtils.escapeQueryChars((String)format) + "]");
    }
}

