/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.xoai;

import com.google.common.base.Function;
import com.lyncode.builder.ListBuilder;
import com.lyncode.xoai.dataprovider.core.ListItemIdentifiersResult;
import com.lyncode.xoai.dataprovider.core.ListItemsResults;
import com.lyncode.xoai.dataprovider.data.Item;
import com.lyncode.xoai.dataprovider.data.ItemIdentifier;
import com.lyncode.xoai.dataprovider.exceptions.IdDoesNotExistException;
import com.lyncode.xoai.dataprovider.filter.ScopedFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.dspace.xoai.data.DSpaceSolrItem;
import org.dspace.xoai.services.api.CollectionsService;
import org.dspace.xoai.services.api.HandleResolver;
import org.dspace.xoai.services.api.solr.SolrQueryResolver;
import org.dspace.xoai.services.impl.xoai.DSpaceItemRepository;
import org.dspace.xoai.solr.DSpaceSolrSearch;
import org.dspace.xoai.solr.exceptions.DSpaceSolrException;
import org.dspace.xoai.solr.exceptions.SolrSearchEmptyException;

public class DSpaceItemSolrRepository
extends DSpaceItemRepository {
    private static Logger log = LogManager.getLogger(DSpaceItemSolrRepository.class);
    private SolrServer server;
    private SolrQueryResolver solrQueryResolver;

    public DSpaceItemSolrRepository(SolrServer server, CollectionsService collectionsService, HandleResolver handleResolver, SolrQueryResolver solrQueryResolver) {
        super(collectionsService, handleResolver);
        this.server = server;
        this.solrQueryResolver = solrQueryResolver;
    }

    public Item getItem(String identifier) throws IdDoesNotExistException {
        if (identifier == null) {
            throw new IdDoesNotExistException();
        }
        String[] parts = identifier.split(Pattern.quote(":"));
        if (parts.length == 3) {
            try {
                SolrQuery params = new SolrQuery("item.handle:" + parts[2]);
                return new DSpaceSolrItem(DSpaceSolrSearch.querySingle(this.server, params));
            }
            catch (SolrSearchEmptyException ex) {
                throw new IdDoesNotExistException((Exception)ex);
            }
        }
        throw new IdDoesNotExistException();
    }

    public ListItemIdentifiersResult getItemIdentifiers(List<ScopedFilter> filters, int offset, int length) {
        try {
            QueryResult queryResult = this.retrieveItems(filters, offset, length);
            List identifierList = new ListBuilder().add((Collection)queryResult.getResults()).build((Function)new Function<Item, ItemIdentifier>(){

                public ItemIdentifier apply(Item elem) {
                    return elem;
                }
            });
            return new ListItemIdentifiersResult(queryResult.hasMore(), identifierList, queryResult.getTotal());
        }
        catch (DSpaceSolrException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return new ListItemIdentifiersResult(false, new ArrayList());
        }
    }

    public ListItemsResults getItems(List<ScopedFilter> filters, int offset, int length) {
        try {
            QueryResult queryResult = this.retrieveItems(filters, offset, length);
            return new ListItemsResults(queryResult.hasMore(), queryResult.getResults(), queryResult.getTotal());
        }
        catch (DSpaceSolrException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return new ListItemsResults(false, new ArrayList());
        }
    }

    private QueryResult retrieveItems(List<ScopedFilter> filters, int offset, int length) throws DSpaceSolrException {
        ArrayList<DSpaceSolrItem> list = new ArrayList<DSpaceSolrItem>();
        SolrQuery params = new SolrQuery(this.solrQueryResolver.buildQuery(filters)).setRows(Integer.valueOf(length)).setStart(Integer.valueOf(offset));
        SolrDocumentList solrDocuments = DSpaceSolrSearch.query(this.server, params);
        for (SolrDocument doc : solrDocuments) {
            list.add(new DSpaceSolrItem(doc));
        }
        return new QueryResult(list, solrDocuments.getNumFound() > (long)(offset + length), (int)solrDocuments.getNumFound());
    }

    private class QueryResult {
        private List<Item> results;
        private boolean hasMore;
        private int total;

        private QueryResult(List<Item> results, boolean hasMore, int total) {
            this.results = results;
            this.hasMore = hasMore;
            this.total = total;
        }

        private List<Item> getResults() {
            return this.results;
        }

        private boolean hasMore() {
            return this.hasMore;
        }

        private int getTotal() {
            return this.total;
        }
    }
}

