/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.xoai;

import com.lyncode.xoai.dataprovider.core.DeleteMethod;
import com.lyncode.xoai.dataprovider.core.Granularity;
import com.lyncode.xoai.dataprovider.services.api.RepositoryConfiguration;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.xoai.exceptions.InvalidMetadataFieldException;
import org.dspace.xoai.services.api.EarliestDateResolver;
import org.dspace.xoai.services.api.config.ConfigurationService;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DSpaceRepositoryConfiguration
implements RepositoryConfiguration {
    private static Logger log = LogManager.getLogger(DSpaceRepositoryConfiguration.class);
    private List<String> emails = null;
    private String name = null;
    private String baseUrl = null;
    private Context context;
    private EarliestDateResolver dateResolver;
    private ConfigurationService configurationService;

    public DSpaceRepositoryConfiguration(EarliestDateResolver dateResolver, ConfigurationService configurationService, Context context) {
        this.dateResolver = dateResolver;
        this.configurationService = configurationService;
        this.context = context;
    }

    public List<String> getAdminEmails() {
        if (this.emails == null) {
            this.emails = new ArrayList<String>();
            String result = this.configurationService.getProperty("mail.admin");
            if (result == null) {
                log.warn((Object)"{ OAI 2.0 :: DSpace } Not able to retrieve the mail.admin property from the configuration file");
            } else {
                this.emails.add(result);
            }
        }
        return this.emails;
    }

    public String getBaseUrl() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        if (this.baseUrl == null) {
            this.baseUrl = this.configurationService.getProperty("oai.url");
            if (this.baseUrl == null) {
                log.warn((Object)"{ OAI 2.0 :: DSpace } Not able to retrieve the oai.url property from oai.cfg. Falling back to request address");
                this.baseUrl = request.getRequestURL().toString().replace(request.getPathInfo(), "");
            }
        }
        return this.baseUrl + request.getPathInfo();
    }

    public DeleteMethod getDeleteMethod() {
        return DeleteMethod.TRANSIENT;
    }

    public Date getEarliestDate() {
        try {
            return this.dateResolver.getEarliestDate(this.context);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidMetadataFieldException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return new Date();
    }

    public Granularity getGranularity() {
        return Granularity.Second;
    }

    public String getRepositoryName() {
        if (this.name == null) {
            this.name = this.configurationService.getProperty("dspace.name");
            if (this.name == null) {
                log.warn((Object)"{ OAI 2.0 :: DSpace } Not able to retrieve the dspace.name property from the configuration file");
                this.name = "OAI Repository";
            }
        }
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getDescription() {
        ArrayList<String> result = new ArrayList<String>();
        String descriptionFile = this.configurationService.getProperty("oai", "description.file");
        if (descriptionFile == null) {
            boolean stop = false;
            ArrayList<String> descriptionFiles = new ArrayList<String>();
            int i = 0;
            while (!stop) {
                String tmp = this.configurationService.getProperty("oai", "description.file." + i);
                if (tmp == null) {
                    stop = true;
                } else {
                    descriptionFiles.add(tmp);
                }
                ++i;
            }
            for (String path : descriptionFiles) {
                try {
                    File f = new File(path);
                    if (!f.exists()) continue;
                    result.add(FileUtils.readFileToString((File)f));
                }
                catch (IOException e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            return result;
        } else {
            try {
                File f = new File(descriptionFile);
                if (!f.exists()) return result;
                result.add(FileUtils.readFileToString((File)f));
                return result;
            }
            catch (IOException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

