/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.xoai;

import com.lyncode.xoai.dataprovider.core.ListSetsResult;
import com.lyncode.xoai.dataprovider.core.Set;
import com.lyncode.xoai.dataprovider.services.api.SetRepository;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.xoai.data.DSpaceSet;

public class DSpaceSetRepository
implements SetRepository {
    private static final Logger log = LogManager.getLogger(DSpaceSetRepository.class);
    private final Context _context;
    private final HandleService handleService;
    private final CommunityService communityService;
    private final CollectionService collectionService;

    public DSpaceSetRepository(Context context) {
        this._context = context;
        this.handleService = HandleServiceFactory.getInstance().getHandleService();
        this.communityService = ContentServiceFactory.getInstance().getCommunityService();
        this.collectionService = ContentServiceFactory.getInstance().getCollectionService();
    }

    private int getCommunityCount() {
        try {
            List communityList = this.communityService.findAll(this._context);
            return communityList.size();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    private int getCollectionCount() {
        try {
            List collectionList = this.collectionService.findAll(this._context);
            return collectionList.size();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    private List<Set> community(int offset, int length) {
        ArrayList<Set> array = new ArrayList<Set>();
        try {
            List communityList = this.communityService.findAll(this._context, Integer.valueOf(length), Integer.valueOf(offset));
            for (Community community : communityList) {
                array.add(DSpaceSet.newDSpaceCommunitySet(community.getHandle(), community.getName()));
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return array;
    }

    private List<Set> collection(int offset, int length) {
        ArrayList<Set> array = new ArrayList<Set>();
        try {
            List collectionList = this.collectionService.findAll(this._context, Integer.valueOf(length), Integer.valueOf(offset));
            for (Collection collection : collectionList) {
                array.add(DSpaceSet.newDSpaceCollectionSet(collection.getHandle(), collection.getName()));
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return array;
    }

    public ListSetsResult retrieveSets(int offset, int length) {
        log.debug((Object)("Querying sets. Offset: " + offset + " - Length: " + length));
        ArrayList<Set> array = new ArrayList<Set>();
        int communityCount = this.getCommunityCount();
        log.debug((Object)("Communities: " + communityCount));
        int collectionCount = this.getCollectionCount();
        log.debug((Object)("Collections: " + collectionCount));
        if (offset < communityCount) {
            if (offset + length > communityCount) {
                List<Set> tmp = this.community(offset, length);
                array.addAll(tmp);
                array.addAll(this.collection(0, length - tmp.size()));
            } else {
                array.addAll(this.community(offset, length));
            }
        } else if (offset < communityCount + collectionCount) {
            array.addAll(this.collection(offset - communityCount, length));
        }
        log.debug((Object)("Has More Results: " + (offset + length < communityCount + collectionCount ? "Yes" : "No")));
        return new ListSetsResult(offset + length < communityCount + collectionCount, array, communityCount + collectionCount);
    }

    public boolean supportSets() {
        return true;
    }

    public boolean exists(String setSpec) {
        if (setSpec.startsWith("col_")) {
            try {
                DSpaceObject dso = this.handleService.resolveToObject(this._context, setSpec.replace("col_", "").replace("_", "/"));
                return dso != null && dso instanceof Collection;
            }
            catch (SQLException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else if (setSpec.startsWith("com_")) {
            try {
                DSpaceObject dso = this.handleService.resolveToObject(this._context, setSpec.replace("com_", "").replace("_", "/"));
                return dso != null && dso instanceof Community;
            }
            catch (SQLException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return false;
    }
}

