/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.util;

import com.lyncode.xoai.dataprovider.xml.xoai.Element;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import com.lyncode.xoai.util.Base64Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.app.util.factory.UtilServiceFactory;
import org.dspace.app.util.service.MetadataExposureService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.util.URLUtils;

public class ItemUtils {
    private static final Logger log = LogManager.getLogger(ItemUtils.class);
    private static final MetadataExposureService metadataExposureService = UtilServiceFactory.getInstance().getMetadataExposureService();
    private static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    private static Element getElement(List<Element> list, String name) {
        for (Element e : list) {
            if (!name.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    private static Element create(String name) {
        Element e = new Element();
        e.setName(name);
        return e;
    }

    private static Element.Field createValue(String name, String value) {
        Element.Field e = new Element.Field();
        e.setValue(value);
        e.setName(name);
        return e;
    }

    public static Metadata retrieveMetadata(Context context, Item item) {
        Metadata metadata = new Metadata();
        List vals = itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*");
        for (MetadataValue val : vals) {
            Element language;
            MetadataField field = val.getMetadataField();
            try {
                if (metadataExposureService.isHidden(context, field.getMetadataSchema().getName(), field.getElement(), field.getQualifier())) {
                    continue;
                }
            }
            catch (SQLException se) {
                throw new RuntimeException(se);
            }
            Element valueElem = null;
            Element schema = ItemUtils.getElement(metadata.getElement(), field.getMetadataSchema().getName());
            if (schema == null) {
                schema = ItemUtils.create(field.getMetadataSchema().getName());
                metadata.getElement().add(schema);
            }
            valueElem = schema;
            if (field.getElement() != null && !field.getElement().equals("")) {
                Element element = ItemUtils.getElement(schema.getElement(), field.getElement());
                if (element == null) {
                    element = ItemUtils.create(field.getElement());
                    schema.getElement().add(element);
                }
                valueElem = element;
                if (field.getQualifier() != null && !field.getQualifier().equals("")) {
                    Element qualifier = ItemUtils.getElement(element.getElement(), field.getQualifier());
                    if (qualifier == null) {
                        qualifier = ItemUtils.create(field.getQualifier());
                        element.getElement().add(qualifier);
                    }
                    valueElem = qualifier;
                }
            }
            if (val.getLanguage() != null && !val.getLanguage().equals("")) {
                language = ItemUtils.getElement(valueElem.getElement(), val.getLanguage());
                if (language == null) {
                    language = ItemUtils.create(val.getLanguage());
                    valueElem.getElement().add(language);
                }
                valueElem = language;
            } else {
                language = ItemUtils.getElement(valueElem.getElement(), "none");
                if (language == null) {
                    language = ItemUtils.create("none");
                    valueElem.getElement().add(language);
                }
                valueElem = language;
            }
            valueElem.getField().add(ItemUtils.createValue("value", val.getValue()));
            if (val.getAuthority() == null) continue;
            valueElem.getField().add(ItemUtils.createValue("authority", val.getAuthority()));
            if (val.getConfidence() == 0) continue;
            valueElem.getField().add(ItemUtils.createValue("confidence", val.getConfidence() + ""));
        }
        Element bundles = ItemUtils.create("bundles");
        metadata.getElement().add(bundles);
        try {
            List bs = item.getBundles();
            for (Bundle b : bs) {
                Element bundle = ItemUtils.create("bundle");
                bundles.getElement().add(bundle);
                bundle.getField().add(ItemUtils.createValue("name", b.getName()));
                Element bitstreams = ItemUtils.create("bitstreams");
                bundle.getElement().add(bitstreams);
                List bits = b.getBitstreams();
                for (Bitstream bit : bits) {
                    List bi;
                    Element bitstream = ItemUtils.create("bitstream");
                    bitstreams.getElement().add(bitstream);
                    String url = "";
                    String bsName = bit.getName();
                    String sid = String.valueOf(bit.getSequenceID());
                    String baseUrl = ConfigurationManager.getProperty((String)"oai", (String)"bitstream.baseUrl");
                    String handle = null;
                    List bn = bit.getBundles();
                    if (!bn.isEmpty() && !(bi = ((Bundle)bn.get(0)).getItems()).isEmpty()) {
                        handle = ((Item)bi.get(0)).getHandle();
                    }
                    if (bsName == null) {
                        List ext = bit.getFormat(context).getExtensions();
                        bsName = "bitstream_" + sid + (ext.isEmpty() ? "" : (String)ext.get(0));
                    }
                    url = handle != null && baseUrl != null ? baseUrl + "/bitstream/" + handle + "/" + sid + "/" + URLUtils.encode(bsName) : URLUtils.encode(bsName);
                    String cks = bit.getChecksum();
                    String cka = bit.getChecksumAlgorithm();
                    String oname = bit.getSource();
                    String name = bit.getName();
                    String description = bit.getDescription();
                    if (name != null) {
                        bitstream.getField().add(ItemUtils.createValue("name", name));
                    }
                    if (oname != null) {
                        bitstream.getField().add(ItemUtils.createValue("originalName", name));
                    }
                    if (description != null) {
                        bitstream.getField().add(ItemUtils.createValue("description", description));
                    }
                    bitstream.getField().add(ItemUtils.createValue("format", bit.getFormat(context).getMIMEType()));
                    bitstream.getField().add(ItemUtils.createValue("size", "" + bit.getSize()));
                    bitstream.getField().add(ItemUtils.createValue("url", url));
                    bitstream.getField().add(ItemUtils.createValue("checksum", cks));
                    bitstream.getField().add(ItemUtils.createValue("checksumAlgorithm", cka));
                    bitstream.getField().add(ItemUtils.createValue("sid", bit.getSequenceID() + ""));
                }
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        Element other = ItemUtils.create("others");
        other.getField().add(ItemUtils.createValue("handle", item.getHandle()));
        other.getField().add(ItemUtils.createValue("identifier", DSpaceItem.buildIdentifier(item.getHandle())));
        other.getField().add(ItemUtils.createValue("lastModifyDate", item.getLastModified().toString()));
        metadata.getElement().add(other);
        Element repository = ItemUtils.create("repository");
        repository.getField().add(ItemUtils.createValue("name", ConfigurationManager.getProperty((String)"dspace.name")));
        repository.getField().add(ItemUtils.createValue("mail", ConfigurationManager.getProperty((String)"mail.admin")));
        metadata.getElement().add(repository);
        Element license = ItemUtils.create("license");
        try {
            Bundle licBundle;
            List licBits;
            List licBundles = itemService.getBundles(item, "LICENSE");
            if (!licBundles.isEmpty() && !(licBits = (licBundle = (Bundle)licBundles.get(0)).getBitstreams()).isEmpty()) {
                Bitstream licBit = (Bitstream)licBits.get(0);
                try {
                    InputStream in = bitstreamService.retrieve(context, licBit);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Utils.bufferedCopy((InputStream)in, (OutputStream)out);
                    license.getField().add(ItemUtils.createValue("bin", Base64Utils.encode((String)out.toString())));
                    metadata.getElement().add(license);
                }
                catch (IOException | SQLException | AuthorizeException e) {
                    log.warn((Object)e.getMessage(), e);
                }
            }
        }
        catch (SQLException e1) {
            log.warn((Object)e1.getMessage(), (Throwable)e1);
        }
        return metadata;
    }
}

