/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import com.google.common.base.Function;
import com.lyncode.builder.ListBuilder;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.ParameterList;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.ParameterValue;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.SimpleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceAtLeastOneMetadataFilter;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.data.DSpaceMetadataFilterOperator;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class DSpaceAtLeastOneMetadataFilter
extends DSpaceFilter {
    private static final Logger log = LogManager.getLogger(DSpaceAtLeastOneMetadataFilter.class);
    private String field;
    private DSpaceMetadataFilterOperator operator = DSpaceMetadataFilterOperator.UNDEF;
    private List<String> values;

    private String getField() {
        if (this.field == null) {
            this.field = this.getConfiguration().get("field").asSimpleType().asString();
        }
        return this.field;
    }

    private List<String> getValues() {
        if (this.values == null) {
            ParameterValue parameterValue = this.getConfiguration().get("value");
            if (parameterValue == null) {
                parameterValue = this.getConfiguration().get("values");
            }
            if (parameterValue instanceof SimpleType) {
                this.values = new ArrayList();
                this.values.add(((SimpleType)parameterValue).asString());
            } else {
                this.values = parameterValue instanceof ParameterList ? new ListBuilder().add((Collection)parameterValue.asParameterList().getValues()).build((Function)new /* Unavailable Anonymous Inner Class!! */) : new ArrayList();
            }
        }
        return this.values;
    }

    private DSpaceMetadataFilterOperator getOperator() {
        if (this.operator == DSpaceMetadataFilterOperator.UNDEF) {
            this.operator = DSpaceMetadataFilterOperator.valueOf((String)this.getConfiguration().get("operator").asSimpleType().asString().toUpperCase());
        }
        return this.operator;
    }

    public boolean isShown(DSpaceItem item) {
        if (this.getField() == null) {
            return true;
        }
        List values = item.getMetadata(this.getField());
        for (String praticalValue : values) {
            block10: for (String theoreticValue : this.getValues()) {
                switch (2.$SwitchMap$org$dspace$xoai$filter$data$DSpaceMetadataFilterOperator[this.getOperator().ordinal()]) {
                    case 1: {
                        if (!praticalValue.startsWith(theoreticValue)) continue block10;
                        return true;
                    }
                    case 2: {
                        if (!praticalValue.endsWith(theoreticValue)) continue block10;
                        return true;
                    }
                    case 3: {
                        if (!praticalValue.equals(theoreticValue)) continue block10;
                        return true;
                    }
                    case 4: {
                        if (praticalValue.compareTo(theoreticValue) <= 0) continue block10;
                        return true;
                    }
                    case 5: {
                        if (praticalValue.compareTo(theoreticValue) < 0) continue block10;
                        return true;
                    }
                    case 6: {
                        if (praticalValue.compareTo(theoreticValue) >= 0) continue block10;
                        return true;
                    }
                    case 7: {
                        if (praticalValue.compareTo(theoreticValue) > 0) continue block10;
                        return true;
                    }
                }
                if (!praticalValue.contains(theoreticValue)) continue;
                return true;
            }
        }
        return false;
    }

    public SolrFilterResult buildSolrQuery() {
        String field = this.getField();
        ArrayList parts = new ArrayList();
        if (this.getField() != null) {
            for (String v : this.getValues()) {
                this.buildQuery("metadata." + field, ClientUtils.escapeQueryChars((String)v), parts);
            }
            if (parts.size() > 0) {
                return new SolrFilterResult(StringUtils.join(parts.iterator(), (String)" OR "));
            }
        }
        return new SolrFilterResult();
    }

    private void buildQuery(String field, String value, List<String> parts) {
        switch (2.$SwitchMap$org$dspace$xoai$filter$data$DSpaceMetadataFilterOperator[this.getOperator().ordinal()]) {
            case 2: {
                parts.add("(" + field + ":*" + value + ")");
                break;
            }
            case 1: {
                parts.add("(" + field + ":" + value + "*)");
                break;
            }
            case 3: {
                parts.add("(" + field + ":" + value + ")");
                break;
            }
            case 4: {
                parts.add("(" + field + ":[" + value + " TO *])");
                break;
            }
            case 6: {
                parts.add("(" + field + ":[* TO " + value + "])");
                break;
            }
            case 7: {
                parts.add("(-(" + field + ":[" + value + " TO *]))");
                break;
            }
            case 5: {
                parts.add("(-(" + field + ":[* TO " + value + "]))");
                break;
            }
            default: {
                parts.add("(" + field + ":*" + value + "*)");
            }
        }
    }
}

