/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import java.sql.SQLException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class DSpaceAuthorizationFilter
extends DSpaceFilter {
    private static final Logger log = LogManager.getLogger(DSpaceAuthorizationFilter.class);
    private static final AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    private static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    public boolean isShown(DSpaceItem item) {
        boolean pub = false;
        try {
            String handle = DSpaceItem.parseHandle((String)item.getIdentifier());
            if (handle == null) {
                return false;
            }
            Item dspaceItem = (Item)handleService.resolveToObject(this.context, handle);
            if (dspaceItem == null) {
                return false;
            }
            pub = authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)dspaceItem, 0);
        }
        catch (SQLException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return pub;
    }

    public SolrFilterResult buildSolrQuery() {
        return new SolrFilterResult("item.public:true");
    }
}

