/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import com.lyncode.builder.DateBuilder;
import com.lyncode.xoai.dataprovider.services.api.DateProvider;
import com.lyncode.xoai.dataprovider.services.impl.BaseDateProvider;
import java.util.Date;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class DateFromFilter
extends DSpaceFilter {
    private static final DateProvider dateProvider = new BaseDateProvider();
    private final Date date;

    public DateFromFilter(Date date) {
        this.date = new DateBuilder(date).setMinMilliseconds().build();
    }

    public boolean isShown(DSpaceItem item) {
        return item.getDatestamp().compareTo(this.date) >= 0;
    }

    public SolrFilterResult buildSolrQuery() {
        String format = dateProvider.format(this.date).replace("Z", ".000Z");
        return new SolrFilterResult("item.lastmodified:[" + ClientUtils.escapeQueryChars((String)format) + " TO *]");
    }
}

