/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.xoai.services.api.CollectionsService;
import org.dspace.xoai.services.api.context.ContextService;
import org.dspace.xoai.services.api.context.ContextServiceException;

public class DSpaceCollectionsService
implements CollectionsService {
    private static final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();

    public List<UUID> getAllSubCollections(ContextService contextService, UUID communityId) throws SQLException {
        LinkedList<Object> comqueue = new LinkedList<Object>();
        ArrayList<UUID> list = new ArrayList<UUID>();
        try {
            comqueue.add(communityService.find(contextService.getContext(), communityId));
        }
        catch (ContextServiceException e) {
            throw new SQLException(e);
        }
        while (!comqueue.isEmpty()) {
            Community c = (Community)comqueue.poll();
            for (Community sub : c.getSubcommunities()) {
                comqueue.add(sub);
            }
            for (Collection col : c.getCollections()) {
                if (list.contains(col.getID())) continue;
                list.add(col.getID());
            }
        }
        return list;
    }

    public List<Community> flatParentCommunities(Collection c) throws SQLException {
        LinkedList<Community> queue = new LinkedList<Community>();
        ArrayList<Community> result = new ArrayList<Community>();
        for (Community com : c.getCommunities()) {
            queue.add(com);
        }
        while (!queue.isEmpty()) {
            Community p = (Community)queue.poll();
            List par = p.getParentCommunities();
            if (par != null) {
                queue.addAll(par);
            }
            if (result.contains(p)) continue;
            result.add(p);
        }
        return result;
    }

    public List<Community> flatParentCommunities(Community c) throws SQLException {
        LinkedList<Community> queue = new LinkedList<Community>();
        ArrayList<Community> result = new ArrayList<Community>();
        queue.add(c);
        while (!queue.isEmpty()) {
            Community p = (Community)queue.poll();
            List par = p.getParentCommunities();
            if (par != null) {
                queue.addAll(par);
            }
            if (result.contains(p)) continue;
            result.add(p);
        }
        return result;
    }

    public List<Community> flatParentCommunities(Context context, Item c) throws SQLException {
        LinkedList queue = new LinkedList();
        ArrayList<Community> result = new ArrayList<Community>();
        for (Collection collection : c.getCollections()) {
            queue.addAll(communityService.getAllParents(context, collection));
        }
        while (!queue.isEmpty()) {
            Community p = (Community)queue.poll();
            List par = p.getParentCommunities();
            if (par != null) {
                queue.addAll(par);
            }
            if (result.contains(p)) continue;
            result.add(p);
        }
        return result;
    }
}

