/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.dspace.content.MetadataField;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.xoai.exceptions.InvalidMetadataFieldException;
import org.dspace.xoai.services.api.FieldResolver;
import org.dspace.xoai.services.impl.MetadataFieldCache;

public class DSpaceFieldResolver
implements FieldResolver {
    private MetadataFieldCache metadataFieldCache = null;
    private static final MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getFieldID(Context context, String field) throws InvalidMetadataFieldException, SQLException {
        MetadataField metadataField;
        if (this.metadataFieldCache == null) {
            this.metadataFieldCache = new MetadataFieldCache();
        }
        if (this.metadataFieldCache.hasField(field)) return this.metadataFieldCache.getField(field);
        String[] pieces = field.split(Pattern.quote("."));
        if (pieces.length <= 1) throw new InvalidMetadataFieldException();
        String schema = pieces[0];
        String element = pieces[1];
        String qualifier = null;
        if (pieces.length > 2) {
            qualifier = pieces[2];
        }
        if (null == (metadataField = metadataFieldService.findByElement(context, schema, element, qualifier))) throw new InvalidMetadataFieldException();
        this.metadataFieldCache.add(field, metadataField.getID().intValue());
        return this.metadataFieldCache.getField(field);
    }
}

